<?php
ob_start('ob_gzhandler');
header('Content-Encoding: gzip');
require 'autoload.php';
require 'utils.php';
use src\router\Route;
$route = new Route();
config();
/**
 * verificamos si paso 1 dia desde ultiam actualizacion 
 */

if (verifyTimeUpdate()) {
    //actualizo time de update en archivo configuracion
    actualizaJson(CONFIG_APP['configApp'], 'timeUpdate', time());
    // verifico version remota
    $remoteVersion = getUrl(CONFIG_APP['urlVersion']);
    // actualizo valor de version remota archivo configuracion    
    actualizaJson(CONFIG_APP['configApp'], 'appRemoteVersion', $remoteVersion);
    /**
     * verificamos si la version local es menor que la version remota
     */
    if (CONFIG_APP['appRemoteVersion'] > CONFIG_APP['appVersion']) {
        // actualizo TRUE verificacion update en archivo configuracion (no se para que lo uso)
        actualizaJson(CONFIG_APP['configApp'], 'updateVerify', true);
       // actualizo FALSE verificacion update FIle en archivo configuracion (no se para que lo uso)
        $existeUpdateFile=file_exists(CONFIG_APP['appRemoteVersion'].CONFIG_APP['fileUpdate']);
        actualizaJson(CONFIG_APP['configApp'], 'updateFile', $existeUpdateFile);
        // traigo archivo de log update, con los cambios de version
        $updateLog = getUrl(CONFIG_APP['urlLog']);
        // actualizo datos locales de log
        $localUpdateLog = getUrl(CONFIG_APP['updateLog']);
        file_put_contents(CONFIG_APP['updateLog'], $updateLog);
    } else {
        actualizaJson(CONFIG_APP['configApp'], 'updateVerify', false);
        actualizaJson(CONFIG_APP['configApp'], 'updateFile', false);
    }
}

// debug($route, __LINE__,true);
// Imprimimos información de depuración sobre la instancia de Route
if (isset($_GET['route'])) {
    debug($route, __LINE__, true);
}
// Ejecutamos el enrutamiento y obtenemos el resultado
$resultado = $route->dispatch();
echo $resultado;
// Finalizar la salida en búfer y enviar al cliente
ob_end_flush();
