function actualizarAcept(button) {
    // Desactiva el botón
    button.disabled = true;

    // Obtiene el elemento de texto del botón
    const btnText = button.querySelector('.btn-text');
    // Cambia el texto del botón
    btnText.innerText = 'Procesando...';

    // Muestra la barra de progreso en línea
    const progressBarContainer = document.getElementById("progressContainer");
    progressBarContainer.style.display = "block";

    // Simula la descarga (puedes usar AJAX, Fetch, etc.)
    fetch('/actualizar/download')
        .then(response => {
            if (!response.ok) {
                throw new Error('Error de red - Código de estado: ' + response.status);
            }
            return response.text();
        })
        .then(data => {
            console.log('Datos obtenidos:', data);
            btnText.innerText = 'Instalando...';
            progressBar.value = 90;
            // Agrega un retraso de 1 segundo antes de cambiar a 'Finalizo...'

            delay(1000, function () {
                clearInterval(intervalo);
                progressBar.value = 100;
                btnText.innerText = 'Finalizo...';
            });
            delay(2000, function () {
                window.location.href = '/';
            });
        });

    let progreso = 0;
    let intervalo = setInterval(function () {
        progreso += 1;
        progressBar.value = progreso;
        if (progreso >= 85) {
            clearInterval(intervalo);
            //    window.location.href = '/actualizar/acept';
        }
    }, 200);
}

function delay(timeLap, callback) {
    setTimeout(callback, timeLap);
}

/*
const apiUrl = '$urlVersion';
// Realizar la solicitud fetch
fetch(apiUrl)
    .then(response => {
        // Verificar si la solicitud fue exitosa (código de estado HTTP 200-299)
        if (!response.ok) {
            throw new Error('Error de red - Código de estado: ' + response.status);
        }

        // Parsear la respuesta JSON
        return response.json();
    })
    .then(data => {
        // Manipular los datos obtenidos
        console.log('Datos obtenidos:', data);
    })
    .catch(error => {
        // Manejar errores de red o de la API
        console.error('Error en la solicitud fetch:', error.message);
    });
    */