document.addEventListener("DOMContentLoaded", function () {
    // Seleccionar elementos por ID
    let formNewOrden = document.getElementById("formNewOrden");
    let nombreClienteInput = document.getElementById("NombreCliente");
    let datosEquipoInput = document.getElementById("DatosEquipo");
    let opcionesSelect = document.querySelector("#opciones select");
    let detalleOrdenTextarea = document.getElementById("DetalleOrden");
    let comentarioOrdenTextarea = document.getElementById("ComentarioOrden");
    //    let comentarioElement = document.querySelector('.comentario');
    let enviarButton = document.getElementById("enviar");
    let editarButton = document.getElementById("editar");
    let cancelarButton = document.getElementById("cancelar");
    let resetearButton = document.getElementById("resetear");

    // Eventos
    editarButton.addEventListener("click", function () {
        console.log(opcionesSelect.value);
        editarButton.classList.add("d-none");
        enviarButton.classList.remove("d-none");
        opcionesSelect.removeAttribute("disabled");
        detalleOrdenTextarea.removeAttribute("readonly");
        comentarioOrdenTextarea.removeAttribute("readonly");
    });

    cancelarButton.addEventListener("click", function () {
        window.close();
    });

    resetearButton.addEventListener("click", function () {
        window.location.reload();
        //
    });

    // ... Puedes seguir añadiendo más eventos según tus necesidades ...

    // Ejemplo de cómo obtener el valor seleccionado del select
    opcionesSelect.addEventListener("change", function () {
        let selectedOptionValue = opcionesSelect.value;

        console.log("Opción seleccionada:", selectedOptionValue);
    });
    enviarButton.addEventListener("click", () => {
        console.log("click enviar");
        let selectedOptionValue = opcionesSelect.value;
        const formData = new FormData(formNewOrden);
        sendPost("/orden/edit", formData);
    });


    function sendPost(url, data) {
        const requestOptions = {
            method: "POST",
            body: data,
            redirect: "follow",
        };

        fetch(url, requestOptions)
            .then((response) => response.text())
            .then((result) => {
                console.log(result);
                const mainMsg = document.getElementById("mainOrder");
                const newMsg = '<div class="cliente-success"><span>Orden Actualizada con éxito</span></div>';
                mainMsg.innerHTML = newMsg;
                setTimeout(() => {
                    window.close();
                    if (window.opener && !window.opener.closed) {
                        window.opener.location.reload();
                    }
                }, 1000);
            })
            .catch((error) => console.log("error", error));

    }

});
