window.addEventListener("DOMContentLoaded", (event) => {
    // Toggle the side navigation
    const sidebarToggle = document.body.querySelector("#sidebarToggle");
    if (sidebarToggle) {
        // Uncomment Below to persist sidebar toggle between refreshes
        if (localStorage.getItem('sb|sidebar-toggle') === 'true') {
            document.body.classList.toggle('sb-sidenav-toggled');
        }
        sidebarToggle.addEventListener("click", (event) => {
            event.preventDefault();
            document.body.classList.toggle("sb-sidenav-toggled");
            localStorage.setItem(
                "sb|sidebar-toggle",
                document.body.classList.contains("sb-sidenav-toggled")
            );
        });
    }
});

function togglePanel(id) {
    const panel = document.querySelector(id);
    const isVisible = panel.classList.contains("show");
    const divs = document.querySelectorAll(".collapse");
    divs.forEach(function (element) {
        element.classList.remove("show");
    });
    if (!isVisible) {
        panel.classList.add("show");
    }
}

// function newOrden() {
//     window.open("/orden/nueva", "","toolbar=no, width=600, height=720, top=30, left=300, scrollbars=no");
// }
// function newCliente() {
//     window.open("/cliente/nuevo", "","toolbar=no, width=600, height=720, top=130, left=300, scrollbars=no");
// }
// function newMaterial() {
//     window.open("/material/nuevo", "_blank","toolbar=no, width=600, height=720, top=130, left=300, scrollbars=no");
// }

// function verOrden(id){
//     window.open("/orden/id/"+id, "_blank","toolbar=no, width=600, height=720, top=130, left=300, scrollbars=no");
// }

let nuevaVentana; // Variable para almacenar la referencia de la ventana

function openPage(url) {

    if (nuevaVentana && !nuevaVentana.closed) {
        nuevaVentana.location.href = url;
    } else {

        nuevaVentana = window.open(url, "adminWindow", "toolbar=no, width=640, height=820, top=30, left=300, scrollbars=no");
        
    }
    nuevaVentana.focus();
}

function newContact() {
    openPage("/contacto");
}

function newOrden() {
    openPage("/orden/nueva");
}

function newCliente() {
    openPage("/cliente/nuevo");
}

function newMaterial() {
    openPage("/material/nuevo");
}

function verOrden(id) {
    console.log(id);
    const newWindow = window.open("/orden/id/" + id, "blank", "toolbar=no, width=640, height=800, top=130, left=300, scrollbars=no");
    newWindow.focus();
}