window.addEventListener("DOMContentLoaded", () => {
    const tablaCliente = document.getElementById("tablaClientes");
    const alertaCliente = document.getElementById("alertaCliente");
    const tablaOrden = document.getElementById("tablaOrdenes");
    const miDialogo = document.getElementById('miDialogo');
    const cerrarDialogo = document.getElementById('cerrarDialogo');
    const dialogMsg = document.getElementById('dialogMsg');
    const printButtons = document.querySelectorAll('button[name="print"]');
    /********* ordenes *********/
    if (tablaOrden !== null && tablaOrden !== undefined) {
        //tabla ordenes
        const tablaOrdenes = new DataTable("#tablaOrdenes", {
            responsive: true,
            language: {
                "sProcessing":     "Procesando...",
                "sLengthMenu":     "Mostrar _MENU_ por pagina",
                "sZeroRecords":    "No se encontraron resultados",
                "sEmptyTable":     "Ningún dato disponible en esta tabla",
                "sInfo":           "Mostrando registros del _START_ al _END_ de un total de _TOTAL_ ",
                "sInfoEmpty":      "Mostrando del 0 al 0 de un total de 0 ",
                "sInfoFiltered":   "(filtrado de un total de _MAX_ s)",
                "sInfoPostFix":    "",
                "sSearch":         "Buscar:",
                "sUrl":            "",
                "sInfoThousands":  ",",
                "sLoadingRecords": "Cargando...",
                "oPaginate": {
                    "sFirst":    "Primero",
                    "sLast":     "Último",
                    "sNext":     "Siguiente",
                    "sPrevious": "Anterior"
                },
                "oAria": {
                    "sSortAscending":  ": Activar para ordenar la columna de manera ascendente",
                    "sSortDescending": ": Activar para ordenar la columna de manera descendente"
                }
            },
            fixedColumns: {
                leftColumns: 2, // Número de columnas a fijar desde la izquierda
            },
            columnDefs: [
                {
                    targets: '_all',
                    //       targets: 0, // Aplica solo a la primera columna
                    orderSequence: ["asc", "desc"],
                    className: 'dt-head-center dt-body-center',

                },
                {
                    targets: 0,
                    width: '120px',
                },
                {
                    targets: [1, 4, 5],
                    width: '145px',
                },
                {
                    targets: [1, 6 ],
                    orderable: false,
                },
            ],
            fixedHeader: true,
            scrollCollapse: true,
            scrollY: '65vh',
            pageLength: 25,
            lengthMenu: [5, 10, 25, 50, 100],
            order: [4, "desc"],


        });


        printButtons.forEach(button => {
            button.addEventListener('click', () => {
                const ordenId = button.id.split('-')[1];
                // Realiza alguna acción, por ejemplo, imprimir el ID en la consola
                console.log('Botón de impresión clicado para la orden: ' + ordenId);
                verPrintOrden(ordenId);
            });
        });



        //inputDialog.addEventListener('Change', console.log(inputDialog.value));
        // Obtener el número total de filas después de la búsqueda
        tablaOrdenes.on('search.dt', function () {
            const totalRowsSearch = tablaOrdenes.page.info().recordsDisplay;
            if (totalRowsSearch == 0) {
                const msg = 'No se encontro Ninguna Orden con esas referencias, Verifique texto buscado';
                abrir(msg);
            }
            //   console.log(totalRowsSearch)

        });

        // Escuchar el evento 'draw.dt'
        tablaOrdenes.on('draw.dt', function () {
        });
        // Escuchar el evento 'preDraw.dt'
        tablaOrdenes.on('preDraw.dt', function () {
        });

        // Escuchar el evento 'search'
        tablaOrdenes.on('search', function () {
        });
        // Escuchar evcento close dialog
        cerrarDialogo.addEventListener('click', cerrar)


        // Función para abrir el diálogo
        function abrir(msg) {
            const elementMsg = document.createElement('h3');
            elementMsg.textContent = msg;
            // Corrección: Utiliza innerHTML para establecer el contenido HTML
            dialogMsg.innerHTML = '';
            dialogMsg.appendChild(elementMsg);
            miDialogo.showModal();
        }

        // Función para cerrar el diálogo
        function cerrar() {
            var cuadroDeBusqueda = $('#tablaOrdenes_filter input');
            // Borrar el contenido del cuadro de búsqueda
            cuadroDeBusqueda.val('');
            // Disparar el evento de input en el cuadro de búsqueda para que DataTables lo detecte
            cuadroDeBusqueda.trigger('input');
            // Redibujar la tabla para reflejar los cambios
            tablaOrdenes.search('').draw();
            miDialogo.close();
        }
        if (tablaOrdenes) {
        }



        function ocultarAlerta() {
            //  alertaCliente.classList.add("d-none");
        }
    }

    /********* clientes *********/

    if (tablaCliente !== null && tablaCliente !== undefined) {
        console.log('mierda4');
        //tabla ordenes
        const tablaClientes = new DataTable("#tablaClientes", {
            //   responsive: true,
            language: {
           //     url: '//cdn.datatables.net/plug-ins/2.0.1/i18n/es-AR.json',
            }
        });
        tablaClientes.on('search.dt', function () {
            const totalRowsSearch = tablaClientes.page.info().recordsDisplay;
            if (totalRowsSearch == 0) {
                console.log('asd');
                console.log(totalRowsSearch);
                handleNuevoCliente();
            }
        });
        // Función para abrir el diálogo

    }
    function handleNuevoCliente() {
        console.log("Nuevo");
        openPage("/cliente/nuevo");
        alertaCliente.classList.remove("d-none");
    
        setTimeout(function() {
            alertaCliente.classList.add("d-none");
        }, 2000);
    }    
    function ocultarAlerta() {
        setTimeout(alertaCliente.classList.add("d-none"), 2000);
    }
    function verPrintOrden(id) {

        const newWindow = window.open(
            "orden/print/" + id,
            "blank",
            "toolbar=no, width=1024, height=920, top=130, left=300, scrollbars=no"
        );
        newWindow.focus();
    
        // newWindow.print();
    }

});
function verCliente(id) {
    console.log("Ver cliente con ID:", id);
    const newWindow = window.open(
        "cliente/id/" + id,
        "blank",
        "toolbar=no, width=600, height=720, top=130, left=300, scrollbars=no"
    );
    newWindow.focus();
}