<?php

namespace src\controllers;

use src\views\ActualizaView;

class ActualizarController
{
    public function __construct()
    {
    }
    /**
     * Mostrar listado clientes con resumenes de ordenes
     * 
     */
    public function getActualizar()
    {
        //variables
        $data['titulo2'] = 'Actualiza';

        // Crear una instancia de la vista Home y renderizar
        $view = new ActualizaView();
        $renderView = $view->render($data);
        return $renderView;
    }
    public function getDownload()
    {
        agregarLinea('./log.txt', time() . ': ' . __FILE__ . '-' . __LINE__);
        if (CONFIG_APP['updateFile']) {
            $resultado = true;
        } else {
            $resultado = $this->getRemoteUpdate();
        }
        if ($resultado) {
            agregarLinea('./log.txt', time() . ': ' . __FILE__ . '-' . __LINE__);
            $resultado = $this->getInstallUpdate();
        }
        return $resultado;
    }
    private function getInstallUpdate()
    {

        // Descomprimir el archivo usando ZipArchive
        $fileUpdate = CONFIG_APP['dirUpdate'] . CONFIG_APP['appRemoteVersion'] . CONFIG_APP['fileUpdate'];
        $zip = new \ZipArchive();
        $resultado = $zip->open($fileUpdate);
        //debug($fileUpdate,__LINE__,true);
        if ($resultado === TRUE) {
            // Extraer archivos en el destino
            $zip->extractTo('./');
            $zip->close();
            //            echo '<script>alert("ACTUALIZACION EXITOSA");</script>';
            if (file_exists($fileUpdate)) {
                unlink($fileUpdate);
            }
        } else {
            echo '<script>alert("ERROR ACTUALIZACION ");</script>';
            return false;
            // header('Location: /');            
        }
        return true;
    }
    private function  getRemoteUpdate()
    {
        set_time_limit(0);
        // Configuración de la petición cURL
        $ch = curl_init(CONFIG_APP['urlDev']);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HEADER, true);
        // Configuracion headers, version  y token
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Authorization: Bearer ' . CONFIG_APP['appToken'],
            'Version: ' . CONFIG_APP['appVersion'],
        ]);
        // tiempo espera  indefinido
        curl_setopt($ch, CURLOPT_TIMEOUT, 0);
        // Ejecutar la petición cURL
        $response = curl_exec($ch);
        // Verificar si hay errores
        if (curl_errno($ch)) {
            echo 'Error en la petición cURL: ' . curl_error($ch);
        }

        // Obtener el tamaño del encabezado
        $header_size = curl_getinfo($ch, CURLINFO_HEADER_SIZE);
        // Separar encabezados y cuerpo
        $header = substr($response, 0, $header_size);
        $body = substr($response, $header_size);
        // Obtener el Content-Type del encabezado
        $contentType = curl_getinfo($ch, CURLINFO_CONTENT_TYPE);
        // Cerrar la sesión cURL
        curl_close($ch);
        // Verificar el Content-Type para determinar si es un archivo ZIP
        if (strpos($contentType, 'application/zip') !== false) {
            // Es un archivo ZIP, puedes guardar el cuerpo en un archivo
            file_put_contents(CONFIG_APP['dirUpdate'] . CONFIG_APP['appRemoteVersion'] . CONFIG_APP['fileUpdate'], $body);
            if (file_exists(CONFIG_APP['dirUpdate'] . CONFIG_APP['appRemoteVersion'] . CONFIG_APP['fileUpdate'])) {
                return true;
            } else {

                return false;
            }
        } else {
            echo 'El contenido no es un archivo ZIP.';
            echo '<script>alert("La actualizacion fallo");</script>';
            return false;
        }
        echo '<script>alert(' . __FILE__ . '" Actualizacion exitosa");</script>';
        return true;
    }
}
