<?php

namespace src\controllers;

use src\models\OrdenModel;
use src\models\ClienteModel;
use src\views\ClienteView;
use src\views\NuevoClienteView;
use src\views\ClienteViewId;

class ClienteController
{
    public function __construct()
    {
    }
    /**
     * Mostrar listado clientes con resumenes de ordenes
     * 
     */
    public function getCliente()
    {
        //variables
        $data['titulo2'] = 'Clientes';
        // obtener datos Ordenes Clientes
        $data['clientes'] = $this->getClientesOrdenes();
        $data['contarOrdenes'] = $this->getContarOrdenes();
        // Crear una instancia de la vista Home y renderizar
        $view = new ClienteView();
        $renderView = $view->render($data);
        $renderView = $view->render($data);
        //  debug($data,__LINE__,true);
        return $renderView;
    }
    public function     getClientesOrdenes()
    {
        $clienteModel = new ClienteModel();
        $clientesLista = $clienteModel->clientesOrdenesData();
        return $clientesLista;
    }
    public function     getContarOrdenes()
    {
        $ordenModel = new OrdenModel();
        $contarOrdenes = $ordenModel->contarOrdenes();
        return $contarOrdenes;
    }
    public function getId($id)
    {
        $clienteModel = new ClienteModel();
        $cliente=$clienteModel->getClienteId($id);
        $view = new ClienteViewId();
        $renderView = $view->render($cliente);
        return $renderView;
    }
    public function getNuevo()
    {
        $view = new NuevoClienteView();
        $renderView = $view->render();
        return $renderView;
    }
    public function postNuevo2()
    {
        // valuidacion de datos

        return json_encode($_POST);
    }

    // procesamiento POST neuvo cliente
    public function postNuevo()
    {
        $validPost = true;
        $campoVacio = '';
        foreach ($_POST as $key => $value) {
            if (empty($value)) {
                $validPost = false;
                $campoVacio .= " $key, ";
            }
        }
        if (!$validPost) {
            header("HTTP/1.1 203 ");
            return json_encode([
                'error' => "Faltan campos por rellenar: $campoVacio"
            ]);
        } 
        //{"NombreCliente":"","EmailCliente":"","TelefonoCliente":"","EsWsp":"false"}       
        $nombre_cliente = filter_var($_POST['NombreCliente'], FILTER_SANITIZE_SPECIAL_CHARS);
        $email_cliente = filter_var($_POST['EmailCliente'], FILTER_SANITIZE_SPECIAL_CHARS);
        $telefono_cliente = filter_var($_POST['TelefonoCliente'], FILTER_SANITIZE_SPECIAL_CHARS);
        $es_wsp= filter_var($_POST['EsWsp'], FILTER_SANITIZE_SPECIAL_CHARS);
        $clienteModel = new ClienteModel();
        $result = $clienteModel->crearCliente($nombre_cliente,$email_cliente, $telefono_cliente, $es_wsp);
      //  echo $result;
        header("HTTP/1.1 200 Orden Creada");
        return json_encode($result);
    }
}
