<?php

namespace src\controllers;

use src\models\OrdenModel;
use src\models\ClienteModel;
use src\views\NuevaOrdenView;
use src\views\OrdenViewId;
use src\views\OrdenListView;
use src\models\MarcaModel;
use src\views\PrintOrdenView;

use src\controllers\ClienteController;
use src\views\HomeView;
use src\views\OrdenView;

class OrdenController
{
    // public function getOrden()
    // {
    //     return __CLASS__;
    // }
    public function getId($id)
    {
        $ordenModel = new OrdenModel();
        $viewOrdenId = new OrdenViewId();
        $data = $ordenModel->getOrdenId($id);
        $renderView = $viewOrdenId->render($data);
        return $renderView;
    }
    public function getNueva($id)
    {
        $marcaModel = new MarcaModel();
        $clienteModel = new ClienteModel();
        $marcas = $marcaModel->getMarca();
        $clienteOrden = $clienteModel->getClienteId($id);
        $view = new NuevaOrdenView();
        $data['cliente'] = $clienteOrden;
        $data['marcas'] = $marcas;
        $renderView = $view->render($data);
        return $renderView;
    }

    // procesamiento POST
    public function postNueva()
    {
        $validPost = true;
        $campoVacio = '';
        foreach ($_POST as $key => $value) {
            if (empty($value)) {
                //   $validPost = false;
                $campoVacio .= " $key - $value,";
            }
        }
        
        if (empty($_POST['IdCliente']) || empty($_POST['MarcaEquipo']) || empty($_POST['DetalleOrden'])) {
           $validPost = false;
        }

        if (!$validPost) {
            header("HTTP/1.1 203 ");
            return json_encode([
                'error' => "Faltan campos por rellenar: $campoVacio"
            ]);
        } else {
            //     header("HTTP/1.1 201 ");
            //     return json_encode($_POST);
            // }
            //        INSERT INTO `ordenes_reparacion `(`id_orden`, `marca_equipo`, `nombre_cliente`, `telefono_cliente`, `fecha_inicio`, `fecha_fin`, `fecha_entrega`, `id_estado`, `detalle`, `comentario`) VALUES ('[value-1]','[value-2]','[value-3]','[value-4]','[value-5]','[value-6]','[value-7]','[value-8]','[value-9]','[value-10]')
            // Validar y filtrar datos del formulario

            $data['id_cliente'] = filter_var($_POST['IdCliente'], FILTER_SANITIZE_SPECIAL_CHARS);
            $data['id_marca'] = filter_var($_POST['MarcaEquipo'], FILTER_SANITIZE_SPECIAL_CHARS);
            $data['modelo'] = filter_var($_POST['ModeloEquipo'], FILTER_SANITIZE_SPECIAL_CHARS);
            $data['detalle'] = filter_var($_POST['DetalleOrden'], FILTER_SANITIZE_SPECIAL_CHARS);
            $ordenModel = new OrdenModel();
            $result = $ordenModel->crearOrden($data);
            // $id_orden = selectLastOrdenCliente($data['id_cliente']);
            header("HTTP/1.1 201 Orden Creada");
            return json_encode(["orden" => $result]);
        }
    }
    public function postEdit()
    {
        // recibo orden para editar
        $ordenModel = new OrdenModel();
        switch ($_POST['EstadoOrden']) {
                        case '3':
                $result = $ordenModel->cerrarOrden($_POST);
                break;
            case '4':
                $result = $ordenModel->cerrarOrden($_POST);
                break;
            case '5':
                $result = $ordenModel->entregarOrden($_POST);
                break;
            case '6':
                $result = $ordenModel->cerrarOrden($_POST);
                break;
            default:
                $result = $ordenModel->actualizarOrden($_POST);
                break;
        }
        return $result;
    }
    public function getPrint($id)
    {

        $ordenModel = new OrdenModel();
        $viewOrden = new PrintOrdenView();
        $data = $ordenModel->getOrdenId($id);
        if (array_key_exists('render1', $_GET)) {
            $renderView = $viewOrden->render2($data);
        } else {
            $renderView = $viewOrden->render($data);
        }
        return $renderView;
    }
    public function getUser($id){
        $ordenModel = new OrdenModel();
        //$ordenListView = new OrdenListView();
        $data = $ordenModel->getOrdenUserId($id);
        return null;//$ordenListView->render($data);
    }
    public function getList(){
                      //variables
        $data['titulo2'] = 'Ordenes';
        // obtener datos Ordenes Clientes
        $data['ordenes'] = $this->getOrdenesClientes();
        $data['contarOrdenes'] = $this->getContarOrdenes();
        // Crear una instancia de la vista Home y renderizar
        $view = new OrdenListView();
        $renderView = $view->render($data);
        return $renderView;
    }
    public function     getContarOrdenes()
    {
        $ordenModel = new OrdenModel();
        $contarOrdenes = $ordenModel->contarOrdenes();        
        return $contarOrdenes;
    }
    public function     getOrdenesClientes($id_estado = false)
    {
        $ordenModel = new OrdenModel();
        $ordenesClientes = $ordenModel->getOrdenList(   );
        return $ordenesClientes;
    }
}
