<?php

namespace src\models;

use src\models\DatabaseModel as db;

class ClienteModel
{
    public function __construct()
    {
    }
    public function clientesOrdenesData()
    {
        // $query = "  SELECT 
        //                 clientes.id_cliente, 
        //                 clientes.nombre,
        //                 clientes.telefono,
        //                 clientes.email,
        //                 GROUP_CONCAT(ordenes_reparacion.id_orden) AS lista_ordenes,
        //                 GROUP_CONCAT(ordenes_reparacion.id_estado) AS lista_status,
        //                 GROUP_CONCAT(estados.nombre_estado) AS lista_status_name
        //             FROM 
        //                 clientes
        //             LEFT JOIN 
        //                 ordenes_reparacion ON clientes.id_cliente = ordenes_reparacion.id_cliente
        //             LEFT JOIN
        //                 estados ON ordenes_reparacion.id_estado = estados.id_estado
        //             WHERE  ordenes_reparacion.id_estado !=5
        //             GROUP BY 
        //                 clientes.id_cliente;";
        $query ="SELECT 
                        clientes.id_cliente, 
                        clientes.nombre,
                        clientes.telefono,
                        clientes.email,
                        GROUP_CONCAT(CASE WHEN ordenes_reparacion.id_estado < 5 THEN ordenes_reparacion.id_orden END) AS lista_ordenes,
                        GROUP_CONCAT(CASE WHEN ordenes_reparacion.id_estado < 5 THEN ordenes_reparacion.id_estado END) AS lista_status,
                        GROUP_CONCAT(CASE WHEN ordenes_reparacion.id_estado < 5 THEN estados.nombre_estado END) AS lista_status_name
                    FROM 
                        clientes
                    LEFT JOIN 
                        ordenes_reparacion ON clientes.id_cliente = ordenes_reparacion.id_cliente
                    LEFT JOIN
                        estados ON ordenes_reparacion.id_estado = estados.id_estado
                    GROUP BY 
                        clientes.id_cliente;
                    ";
        $result = db::getInstance()->query($query);
        return $result->fetchAll(\PDO::FETCH_ASSOC);
    }
    public function  crearCliente($nombre_cliente, $email_cliente, $telefono_cliente, $es_wsp)
    {
        try {
            $query = "INSERT INTO `clientes`( `nombre`, `telefono`, `wsp`, `email`)
                VALUES (:nombre, :telefono, :wsp, :email)";
            $consulta = db::getInstance()->prepare($query);
            $consulta->bindParam(':nombre', $nombre_cliente, \PDO::PARAM_STR);
            $consulta->bindParam(':telefono', $telefono_cliente, \PDO::PARAM_STR);
            $consulta->bindParam(':wsp', $es_wsp, \PDO::PARAM_STR);
            $consulta->bindParam(':email', $email_cliente, \PDO::PARAM_STR);
            $result = $consulta->execute();
            if ($result) {
                return json_encode(array('success' => true, 'message' => 'Cliente creado con éxito'));
            } else {
                return json_encode(array('success' => false, 'message' => 'Error al crear el cliente'));
            }
        } catch (\PDOException $e) {
            return json_encode(array('success' => false, 'message' => 'Error de base de datos: ' . $e->getMessage()));
        }
    }
    public function getClienteId($id)
    {
        $query = "SELECT * FROM `clientes` WHERE `id_cliente` = :id";
        $consulta = db::getInstance()->prepare($query);
        $consulta->bindParam(':id', $id, \PDO::PARAM_INT);
        $consulta->execute();  
        //   $result = $consulta->fetchAll(\PDO::FETCH_ASSOC);
        $result = $consulta->fetch(\PDO::FETCH_ASSOC);
        return $result;
    }
}
