<?php

namespace src\models;

use PDO;
use PDOException;

class DatabaseModel
{
    private static $instance;
    protected $connection;

    private function __construct()
    {
        $config = $this->readConfig();
        $this->connect($config);
    }

    private function connect($config)
    {
        try {
            $port = isset($config['port']) ? $config['port'] : 3306;
            $this->connection = new PDO("mysql:host={$config['host']};port={$port};dbname={$config['dbname']}", $config['username'], $config['password']);
            $this->connection->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
            $this->connection->setAttribute(PDO::ATTR_EMULATE_PREPARES, false);
        } catch (PDOException $e) {
            die("Error de conexión a la base de datos: " . $e->getMessage());
        }
    }

    private function readConfig()
    {
        if (CONFIG_DB) {
            return CONFIG_DB;
        } else {
            die("Error: configuración de base de datos no encontrada.");
        }
    }

    public static function getInstance()
    {
        if (!self::$instance) {
            self::$instance = new DatabaseModel();
        }
        return self::$instance->connection;
    }
}
