<?php
namespace src\models;
use src\models\DatabaseModel as db;
class OrdenModel
{
    public function __construct()
    {
    }
    public function getOrdenId($id)
    {
        try {
            //   $query = "SELECT * FROM ordenes_reparacion  WHERE id_orden = :id_orden";
            $query = "SELECT o.* ,
                        c.nombre ,
                        e.nombre_estado as estado,
                        m.marca 
                    FROM `ordenes_reparacion` as o 	
                    JOIN clientes as c                    
                    ON o.id_cliente = c.id_cliente
                    JOIN estados as e
                    ON o.id_estado = e.id_estado
                    JOIN marcas as m
                    ON o.id_marca = m.id_marca
                    WHERE o.id_orden = :id_orden; ";

            $consulta = db::getInstance()->prepare($query);
            $consulta->bindParam(':id_orden', $id, \PDO::PARAM_STR);
            $consulta->execute();
            $result = $consulta->fetchAll(\PDO::FETCH_ASSOC);
            return $result[0];
        } catch (\PDOException $e) {
            echo "Error en la consulta: " . $e->getMessage();
        }
    }
    /**
     * Se utiliza consulta simple, hata tener todos lso formualrios finalizados
     */
    public function ordenesClientesData_v2()
    {
        $query = "SELECT 	o.`id_orden`,
                    o.nombre_cliente as nombre,
                    o.telefono_cliente as telefono,
                    o.fecha_inicio,
                    o.fecha_fin,
                    o.fecha_fin,
                    o.detalle,
                    o.comentario,
                    e.nombre_estado,
                    e.id_estado
                FROM ordenes_reparacion as o 
                LEFT JOIN estados as e 
                ON e.id_estado = o.id_estado                 
              WHERE o.fecha_fin  IS NOT NULFL IS  NULL
                ORDER BY `o`.`fecha_inicio`,o.id_estado ASC;";
        $result = db::getInstance()->query($query);
        return $result->fetchAll(\PDO::FETCH_ASSOC);
    }
    public function ordenesClientesData()
    {
        $query = "SELECT 	o.`id_orden`,
                    o.id_cliente,
                    c.nombre,
                    c.telefono,
                    o.fecha_inicio,
                    o.fecha_fin,
                    o.fecha_fin,
                    o.detalle,
                    o.comentario,
                    e.nombre_estado,
                    e.id_estado
                FROM ordenes_reparacion as o 
                LEFT JOIN estados as e 
                ON e.id_estado = o.id_estado 
                LEFT JOIN clientes as c
                ON o.id_cliente = c.id_cliente
                WHERE (o.id_estado < 5)
               -- WHERE (o.id_estado !=5 OR  o.fecha_entrega IS NULL)
                ORDER BY `o`.`fecha_inicio`,o.id_estado ASC;";
        $result = db::getInstance()->query($query);
        return $result->fetchAll(\PDO::FETCH_ASSOC);
    }
    public function contarOrdenes()
    {
        $query = "SELECT 
                    estados.id_estado,
                    estados.nombre_estado,
                    COUNT(ordenes_reparacion.id_orden) AS cantidad_ordenes,
                    GROUP_CONCAT(ordenes_reparacion.id_orden ORDER BY ordenes_reparacion.id_orden) AS lista_ordenes,
                    GROUP_CONCAT(ordenes_reparacion.fecha_inicio ORDER BY ordenes_reparacion.id_orden) AS fecha_ordenes
                FROM 
                    estados
                LEFT JOIN 
                    ordenes_reparacion ON estados.id_estado = ordenes_reparacion.id_estado
                GROUP BY 
                    estados.id_estado;";
        $result = db::getInstance()->query($query);
        return $result->fetchAll(\PDO::FETCH_ASSOC);
    }
    public function crearOrden($data)
    {
        try {
            extract($data);
            $query = "INSERT INTO `ordenes_reparacion`(`id_marca`, `modelo`, `id_cliente`, `detalle`) 
                    VALUES (:id_marca, :modelo, :id_cliente, :detalle);";

            //$query = "INSERT INTO `ordenes_reparacion` (`marca_equipo`, `nombre_cliente`, `telefono_cliente`, `detalle`)
            //                VALUES (:marca_equipo, :nombre_cliente, :telefono_cliente, :detalle)";
            $consulta = db::getInstance()->prepare($query);
            $consulta->bindParam(':id_marca', $id_marca, \PDO::PARAM_INT);
            $consulta->bindParam(':modelo', $modelo, \PDO::PARAM_STR);
            $consulta->bindParam(':id_cliente', $id_cliente, \PDO::PARAM_INT);
            $consulta->bindParam(':detalle', $detalle, \PDO::PARAM_STR);
            $result = $consulta->execute();
            if ($result) {
                $id_orden = $this->selectLastOrdenCliente($id_cliente);
                return $id_orden;
            }
        } catch (\PDOException $e) {
            return json_encode(array('success' => false, 'message' => 'Error de base de datos: ' . $e->getMessage()));
        }
    }
    public function actualizarOrden($data)
    {

        try {
            
            extract($data);            
            if (!isset($IdOrden)) {
                return json_encode(array('success' => false, 'message' => 'ID de orden no proporcionado'));
            }
            $query = "UPDATE `ordenes_reparacion` SET                    
                    `id_estado` = :id_estado,                     
                    `detalle` = :detalle,
                    `comentario` = :comentario 
                    WHERE `id_orden` = :id_orden;";
            $consulta = db::getInstance()->prepare($query);
            $consulta->bindParam(':id_estado', $EstadoOrden, \PDO::PARAM_STR);
            $consulta->bindParam(':detalle', $DetalleOrden, \PDO::PARAM_STR);
            $consulta->bindParam(':comentario', $ComentarioOrden, \PDO::PARAM_STR);
            $consulta->bindParam(':id_orden', $IdOrden, \PDO::PARAM_STR);
            $result = $consulta->execute();
            if ($result) {
                return json_encode(array('success' => true, 'message' => 'Orden actualizada correctamente'));
            } else {
                return json_encode(array('success' => false, 'message' => 'No se pudo actualizar la orden'));
            }
        } catch (\PDOException $e) {
            return json_encode(array('success' => false, 'message' => 'Error de base de datos: ' . __LINE__ . ' - ' . $e->getMessage()));
        }
    }
    public function cerrarOrden($data)
    {
        try {
            extract($data);
            if (!isset($IdOrden)) {
                return json_encode(array('success' => false, 'message' => 'ID de orden no proporcionado'));
            }

            $query = "UPDATE `ordenes_reparacion` SET                    
                    `id_estado` = :id_estado,                     
                    `detalle` = :detalle,
                    `comentario` = :comentario,
                    `fecha_fin`= now()
                    WHERE `id_orden` = :id_orden;";
            $consulta = db::getInstance()->prepare($query);
            $consulta->bindParam(':id_estado', $EstadoOrden, \PDO::PARAM_STR);
            $consulta->bindParam(':detalle', $DetalleOrden, \PDO::PARAM_STR);
            $consulta->bindParam(':comentario', $ComentarioOrden, \PDO::PARAM_STR);
            $consulta->bindParam(':id_orden', $IdOrden, \PDO::PARAM_STR);
            $result = $consulta->execute();
            if ($result) {
                return json_encode(array('success' => true, 'message' => 'Orden actualizada correctamente'));
            } else {
                return json_encode(array('success' => false, 'message' => 'No se pudo actualizar la orden'));
            }
        } catch (\PDOException $e) {
            return json_encode(array('success' => false, 'message' => 'Error de base de datos: ' . __LINE__ . ' - ' . $e->getMessage()));
        }
    }
    public function anularOrden($data)
    {
        try {
            extract($data);
            if (!isset($IdOrden)) {
                return json_encode(array('success' => false, 'message' => 'ID de orden no proporcionado'));
            }

            $query = "UPDATE `ordenes_reparacion` SET                    
                    `id_estado` = :id_estado,                     
                    `detalle` = :detalle,
                    `comentario` = :comentario,
                    `fecha_fin`= now()
                    WHERE `id_orden` = :id_orden;";
            $consulta = db::getInstance()->prepare($query);
            $consulta->bindParam(':id_estado', $EstadoOrden, \PDO::PARAM_STR);
            $consulta->bindParam(':detalle', $DetalleOrden, \PDO::PARAM_STR);
            $consulta->bindParam(':comentario', $ComentarioOrden, \PDO::PARAM_STR);
            $consulta->bindParam(':id_orden', $IdOrden, \PDO::PARAM_STR);
            $result = $consulta->execute();
            if ($result) {
                return json_encode(array('success' => true, 'message' => 'Orden actualizada correctamente'));
            } else {
                return json_encode(array('success' => false, 'message' => 'No se pudo actualizar la orden'));
            }
        } catch (\PDOException $e) {
            return json_encode(array('success' => false, 'message' => 'Error de base de datos: ' . __LINE__ . ' - ' . $e->getMessage()));
        }
    }
    public function entregarOrden($data)
    {
        try {
            extract($data);
            if (!isset($IdOrden)) {
                return json_encode(array('success' => false, 'message' => 'ID de orden no proporcionado'));
            }

            $query = "UPDATE `ordenes_reparacion` SET                    
                    `id_estado` = :id_estado,                     
                    `detalle` = :detalle,
                    `comentario` = :comentario,
                    `fecha_entrega`= now()
                    WHERE `id_orden` = :id_orden;";
            $consulta = db::getInstance()->prepare($query);
            $consulta->bindParam(':id_estado', $EstadoOrden, \PDO::PARAM_STR);
            $consulta->bindParam(':detalle', $DetalleOrden, \PDO::PARAM_STR);
            $consulta->bindParam(':comentario', $ComentarioOrden, \PDO::PARAM_STR);
            $consulta->bindParam(':id_orden', $IdOrden, \PDO::PARAM_STR);
            $result = $consulta->execute();
            if ($result) {
                return json_encode(array('success' => true, 'message' => 'Orden actualizada correctamente'));
            } else {
                return json_encode(array('success' => false, 'message' => 'No se pudo actualizar la orden'));
            }
        } catch (\PDOException $e) {
            return json_encode(array('success' => false, 'message' => 'Error de base de datos: ' . __LINE__ . ' - ' . $e->getMessage()));
        }
    }
    public function crearOrden2($marca_equipo, $nombre_cliente, $telefono_cliente, $detalle)
    {
        try {
            $query = "INSERT INTO `ordenes_reparacion` (`marca_equipo`, `nombre_cliente`, `telefono_cliente`, `detalle`)
                        VALUES (:marca_equipo, :nombre_cliente, :telefono_cliente, :detalle)";
            $consulta = db::getInstance()->prepare($query);
            $consulta->bindParam(':marca_equipo', $marca_equipo, \PDO::PARAM_STR);
            $consulta->bindParam(':nombre_cliente', $nombre_cliente, \PDO::PARAM_STR);
            $consulta->bindParam(':telefono_cliente', $telefono_cliente, \PDO::PARAM_STR);
            $consulta->bindParam(':detalle', $detalle, \PDO::PARAM_STR);
            $result = $consulta->execute();

            if ($result) {
                return json_encode(array('success' => true, 'message' => 'Orden creada con éxito'));
            } else {
                return json_encode(array('success' => false, 'message' => 'Error al crear la orden'));
            }
        } catch (\PDOException $e) {
            return json_encode(array('success' => false, 'message' => 'Error de base de datos: ' . $e->getMessage()));
        }
    }
    public function selectLastOrdenCliente($id_cliente)
    {
        $query = "    SELECT *
                        FROM `ordenes_reparacion`
                        WHERE id_cliente = :id_cliente
                        ORDER BY id_orden DESC
                        LIMIT 1;
                ";
        $consulta = db::getInstance()->prepare($query);
        $consulta->bindParam(':id_cliente', $id_cliente, \PDO::PARAM_INT);
        $consulta->execute();
        $result = $consulta->fetch(\PDO::FETCH_ASSOC);
        return $result;
    }
    public function getOrdenUserId($id_cliente)
    {
        $query = "    SELECT *
                        FROM `ordenes_reparacion`
                        WHERE id_cliente = :id_cliente
                        ORDER BY id_orden DESC ;
                ";
        $consulta = db::getInstance()->prepare($query);
        $consulta->bindParam(':id_cliente', $id_cliente, \PDO::PARAM_INT);
        $consulta->execute();
        $result = $consulta->fetch(\PDO::FETCH_ASSOC);
        return $result;
    }
        /**
         * Obtiene una lista de órdenes basadas en fechas de inicio y fin especificadas.
         *
         * @param mixed $fecha_inicio La fecha de inicio para filtrar órdenes.
         * @param mixed $fecha_fin La fecha de fin para filtrar órdenes.
         * @return array Lista de órdenes con detalles como id, modelo, cliente, fechas, estado y más.
         */
    public function getOrdenList($fecha_inicio=null, $fecha_fin=null){
        $query = " SELECT o.`id_orden`, o.`id_marca`, o.`modelo`, o.`id_cliente`, o.`fecha_inicio`, o.`fecha_fin`, o.`fecha_entrega`, o.`id_estado`, o.`detalle`, o.`comentario`, o.`presupuesto` ,`c`.`nombre`, e.nombre_estado
        FROM `ordenes_reparacion` as o
        JOIN clientes as c
        ON c.id_cliente =o.id_cliente
        JOIN estados AS e
        ON o.id_estado = e.id_estado 
        WHERE 1=1 ";
        if(!is_null($fecha_inicio)){ $query .= " AND o.fecha_inicio > '2024-01-01' ";}
        if(!is_null($fecha_fin)){$query .= " AND o.fecha_fin < '2024-05-01'";}
        $query .= " ORDER BY o.id_orden DESC ";  
        $result = db::getInstance()->query($query)->fetchAll(\PDO::FETCH_ASSOC);
        return $result;
    }
 
} 
