<?php

namespace src\views;

class ActualizaView
{
    /**
     * @data array de datos a mostrar
     */
    public function render($data = null)
    {
        // Varibles del view
        if ($data) {
            extract($data);
        }
        $headerView = new HeaderView();
        $head = $headerView->render();
        // obtener navbar
        $navBarView = new NavBarView();
        $nav = $navBarView->render($titulo2, false);
        $updateLog = file_get_contents(CONFIG_APP['updateLog']);
        // obtener neuva version
        //  $urlVersion = CONFIG_APP['urlDev'];
        $urlVersion = "/actualizar/download";
        $versionLocal = CONFIG_APP['appVersion'];
        $versionRemote = CONFIG_APP['appRemoteVersion'];
        // Obtener footer
        $footerView = new FooterView();
        $footer = $footerView->render();

        if ($versionLocal < $versionRemote) {
            $msg = " <h1> Actualizacion de sistema</h1> 
                    <p> Existe una version nueva: Version $versionRemote</p>
                    <p style='display:block;'>Puede actualizar si desea.<strong> Esta accion es irreversible</strong>
                    <button class='btn btn-success btn-with-progress' onclick='actualizarAcept(this)'>
                        <span class='btn-text'>Actualizar</span>
                        <span id='progressContainer' style='display:none;'>
                            <progress id='progressBar' value='0' max='100' ></progress>
                        </span>
                        </button>
                    </p>                
                    ";
        } else {
            $msg = ' Su sistema cuenta con la ultima version';
        }
        $html = <<<HTML
            $head
            <body class="sb-nav-fixed">                
                $nav
                <div id="layoutSidenav">                                      
                    <div id="layoutSidenav_content">
                        <main>                                                   
                            <!-- Contenedor Principal  -->
                            <div class="card m-5 position-sticky "
                                style="top:370px; z-index: 1000; background-color: #fafafa;">
                                <div class="card-header">
                                    <i class="fas fa-table me-1"></i>
                                    $msg
                                </div>
                                <div class="card-header">
                                    $updateLog
                                </div>    
                            </div>
                        </div>
                        </main>
                    </div>
                </div>
                <script src="../public/js/actualizar.js"></script>
                </body>
            </html>
        HTML;
        return  $html;
    }
}
