<?php

namespace src\views;

class ClienteView
{
    /**
     * @data array de datos a mostrar
     */
    public function render($data = null)
    {

        // Variables de vista
        $titulo = CONFIG_APP['titulo'];
        // Lógica de presentación del view
        if ($data) {
            extract($data);
            $tablaClientes = $this->tablaClientes($clientes);
            extract($this->cantidadToData($contarOrdenes));
            // array de ordenes con nro y fecha
            $listOrdenes = $this->listOrdenes($contarOrdenes);
            //crea listas de ordenes para resumen
            $listaRecepcionada = $this->crearListaResumen($listOrdenes['recepcionada'], 'list-recepcionada');
            $listaProceso = $this->crearListaResumen($listOrdenes['proceso'], 'list-proceso');
            $listaEntrega = $this->crearListaResumen($listOrdenes['entrega'], 'list-entrega');
            $listaPendiente = $this->crearListaResumen($listOrdenes['pendiente'], 'list-pendiente');
        }
                // Obtener el encabezado
                $headerView = new HeaderView();
                $head = $headerView->render();
                // obtener navbar
                $navBarView= new NavBarView();
                $nav = $navBarView->render($titulo2,false);
                // Obtener footer
                $footerView = new FooterView();
                $footer = $footerView->render();
                // obtener calendario
                $calendarView = new CalendarView();
                $calendar = $calendarView->render();
        
        $html = <<<HTML
            $head
            <body class="sb-nav-fixed">                
                $nav
                <div id="layoutSidenav">
                    <div id="layoutSidenav_nav">
                        <nav class="sb-sidenav accordion sb-sidenav-dark mt-5 p-1 my-5" id="sidenavAccordion">
                            <div class="sb-sidenav-menu">
                                <div class="nav">
                                    $calendar   
                                    <hr class="border border-secondary border-1 opacity-75">
                                    <div class="text-center text-light w-100 pt-1">
                                        <p class="h3">$titulo2</p>
                                    </div>
                                    <!-- ... Contenido de las órdenes ... -->
                                    <div class="mt-2">
                                        <!-- ... Contenido de órdenesPendientes ... -->
                                        <div class="btn btn-warning p-2 w-100 border rounded d-flex justify-content-between align-items-center"
                                            id="ordenesPendientes" onclick="togglePanel('#panel3')" type="button">
                                            Recepcionadas
                                            <span class="border  p-1 rounded bg-light text-warning">
                                                <i class="fas fa-bell "></i>
                                                $count_ordenes_recepcionada
                                            </span>
                                        </div>
                                        <div class="collapse multi-collapse mt-1" id="panel3">
                                            <div class="card card-body text-black">
                                                $listaRecepcionada
                                            </div>
                                        </div>
                                    </div>
                                    <div class="mt-2">
                                        <!-- ... Contenido de órdenesProceso ... -->
                                        <div class="btn btn-primary p-2 w-100 border rounded d-flex justify-content-between align-items-center"
                                            id="ordenesProceso" onclick="togglePanel('#panel2')" type="button">
                                            En Proceso
                                            <span class="border  p-1 rounded bg-light text-primary">
                                                <i class="fas fa-bell "></i>
                                                $count_ordenes_proceso
                                            </span>
                                        </div>
                                        <div class="collapse multi-collapse mt-1" id="panel2">
                                            <div class="card card-body text-black ">
                                                $listaProceso                                                
                                            </div>
                                        </div>
                                    </div>
                                    <div class="mt-2">
                                        <!-- ... Contenido de órdenesObservadas ... -->
                                        <div class="btn btn-danger p-2 w-100 border rounded d-flex justify-content-between align-items-center"
                                            id="ordenesObservadas" onclick="togglePanel('#panel4');" type="button">
                                            Pendientes
                                            <span class="border  p-1 rounded bg-light text-danger">
                                                <i class="fas fa-bell "></i>
                                                $count_ordenes_pendiente
                                            </span>
                                        </div>
                                        <div class="collapse multi-collapse mt-1" id="panel4">
                                            <div class="card card-body text-black">
                                                $listaPendiente
                                            </div>
                                        </div>
                                    </div>
                                    <div class="mt-2">
                                        <!-- ... Contenido de órdenesFinalizadas ... -->
                                        <div class="btn btn-success p-2 w-100 border rounded d-flex justify-content-between align-items-center"
                                            id="ordenesFinalizadas" onclick="togglePanel('#panel1')" type="button">
                                            Para Entrega
                                            <span class="border  p-1 rounded bg-light text-success">
                                                <i class="fas fa-bell "></i>
                                                $count_ordenes_entrega
                                            </span>
                                        </div>
                                        <div class="collapse multi-collapse mt-1" id="panel1">
                                            <div class="card card-body text-black">
                                                $listaEntrega
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </nav>
                    </div>
                        <div id="layoutSidenav_content">
                            <main>
                                <!-- Contenedor Principal  -->
                                <div class="card m-5 position-sticky " style="top:370px; z-index: 1000; background-color: #fafafa;" id="mainContainer">
                                    <div class="card-header">
                                        <i class="fas fa-table me-1"></i> Clientes
                                        <span class="d-none  bg-warning rounded p-2" id="alertaCliente">No se encontro cliente</span>
                                    </div>

                                    <table id="tablaClientes" class="table table-striped display">
                                        <!-- ... Contenido de la tabla de órdenes ... -->
                                        <thead>
                                            <tr>
                                                <th>Nro</th>                                            
                                                <th>Nombre</th>
                                                <th>Admin Cliente</th>                                            
                                                <th>Telefono</th>
                                                <th>Email</th>
                                                <th>Resumen Ordenes Cliente</th>                                            
                                            </tr>
                                        </thead>
                                        
                                        <tbody>
                                            $tablaClientes
                                        </tbody>
                                    </table>
                                    <!-- Paginación de Órdenes -->
                                </div>
                        </div>
                        </main>
                    </div>
                    <!-- Diálogo de HTML5 -->
                    <dialog id="dialogSinClientes">
                        <div>
                            <h2>No existen clientes</h2>
                            <p>Debe crear el primero...</p>
                            <p>Le recomendamos crear uno TALLER que permitira asignar equipos para reparaciones rapidas</p>
                            <p>o equipos propios...</p>
                            <button id="dialogCrearCliente">Crear cliente</button>
                        </div>
                    </dialog>
                    <dialog class="rounded border-1 bg-danger  border-warning" id="miDialogo" show()>
                    <div id="dialogMsg"></div>
                    <button class="btn btn-primary" id="cerrarDialogo">Cerrar</button>                        
                </dialog>
                </div>
                $footer
                <!-- <script src="../public/js/bootstrap.bundle.min.js"></script>
                <script src="../public/js/scripts.js"></script>
                <script src="../public/js/calendar.js"></script>
                <script src="../public/js/simple-datatables.min.js"></script>
                <script src="../public/js/tabla_clientes.js"></script>
            </body>
        </html> -->
        HTML;
        return  $html;
    }
    private function tablaClientes($data)
    {
        $fecha_actual = new \DateTime('now');
        $tabla_body = '';
        foreach ($data as  $value) {
            $id_cliente = $value["id_cliente"];
            $nombre = $value["nombre"];
            $telefono = $value["telefono"];
            $lista_ordenes = $value['lista_ordenes'];
            $lista_status = $value['lista_status'];
            $lista_status_name = $value['lista_status_name'];
            $sin_ordenes = '<span class="badge  btn-success m-1 bg-success px-5 py-2">Cliente Sin ordenes</span>';
            $ordenesCliente = ($lista_ordenes == '') ? $sin_ordenes : $this->listOrdenesCliente($lista_ordenes, $lista_status, $lista_status_name);
            $tabla_body .= <<<HTML
                            <tr>
                                <td>
                                    # $id_cliente  
                                </td>
                                <td>
                                    $nombre
                                </td>    
                                <td> 
                                <button class='btn-hover btn btn-info m-1  ' onclick='openPage("/orden/user/$id_cliente");'>
                                    <i class="edit-user-icon icon "></i>
                                        Ver Ordenes
                                </button>                                
                                <button class='btn-hover btn btn-info m-1  ' onclick='verCliente( $id_cliente);'>
                                    <i class="edit-user-icon icon "></i>
                                        Editar
                                </button>                                
                                <button class='btn-hover btn btn-info m-1' onclick='openPage("/orden/nueva/$id_cliente");'>
                                    <i class="new-orden-icon icon"></i>
                                        Orden
                                </button>                                
                                </td>        

            HTML;
            $tabla_body .= '                <td><a href="https://wa.me/' . $value["telefono"] . '?text=Mensaje%20desde%20{{TITULO}}%20,%20la%20orden%20Nro:%20esta%20 " target="_blank"><i class="fab fa-whatsapp text-success"></i>' . $value["telefono"] . '</a></td>' . PHP_EOL;
            $tabla_body .= '                <td><p class="text-center">' . $value['email'] . '</p></td>' . PHP_EOL;
            $tabla_body .= '                <td>' . PHP_EOL . $ordenesCliente . '</td>' . PHP_EOL;
            $tabla_body .= '             </tr>' . PHP_EOL;
        }
        return $tabla_body;
    }
    private function cantidadToData($countOrdenes)
    {
        $data = [];
        foreach ($countOrdenes as $value) {
            $data['count_ordenes_' . (lcfirst($value['nombre_estado']))] = $value['cantidad_ordenes'];
        }
        return $data;
    }
    private function listOrdenes($countOrdenes)
    {
        $data = [];
        $ordenes[] = '';
        foreach ($countOrdenes as $value) {
            $data[lcfirst($value['nombre_estado'])]['lista_ordenes'] = explode(',', $value['lista_ordenes']);
            $data[lcfirst($value['nombre_estado'])]['fecha_ordenes'] = explode(',', $value['fecha_ordenes']);
        }
        foreach ($data as $key => $value) {
            $ordenes[$key] = array_combine($value['lista_ordenes'], $value['fecha_ordenes']);
        }
        return ($ordenes);
    }

    private function crearListaResumen($ordenes, $class)
    {
        $fecha_actual = new \DateTime('now');
        $html = '<ul class="list-unstyled ordenList">' . PHP_EOL;
        foreach ($ordenes as $key => $value) {
            $fecha_orden = new \DateTime($value);
            $diferencia = $fecha_actual->diff($fecha_orden);
            $html .= ' <li><a  href="#" onclick="verOrden(' . $key . ');event.preventDefault();"> Orden -' . $key . ' - ' . $diferencia->days . ' Dias </a></li>' . PHP_EOL;
            }
        $html .= "</ul>" . PHP_EOL;
        return $html;
    }


    private function listOrdenesCliente($lista_ordenes, $lista_status, $lista_status_name)
    {
        $arrayOrdenes = explode(",", $lista_ordenes);
        $arrayStatus = explode(",", $lista_status);
        $arrayStatusName = explode(",", $lista_status_name);
        $odenesMatriz = array();
        $ordenes = ' <div class="d-inline-block">';
        // Verificar que los tres arrays tienen la misma longitud
        if (count($arrayOrdenes) == count($arrayStatus) && count($arrayStatus) == count($arrayStatusName)) {
            $longitud = count($arrayOrdenes);
            for ($i = 0; $i < $longitud; $i++) {
                $ordenes .= "               <button onclick='verOrden($arrayOrdenes[$i]);' class='btn-hover btn m-1 " . lcfirst($arrayStatusName[$i]) . " '> Orden " . $arrayOrdenes[$i] . "<i class='ms-3 " . lcfirst($arrayStatusName[$i]) . "-icon icon'></i></button>" . PHP_EOL;
            }
            $ordenes .= "</div>";
        } else {
            $ordenes = "Los arrays no tienen la misma longitud.";
        }
        return $ordenes;
    }
}
