<?php

namespace src\views;

class ContactoView
{
    public function render()
    {
        $titulo = 'SOPORTE';
        $html = <<<HTML
                    <!DOCTYPE html>
                    <html lang="es">
                    <head>
                        <meta charset="utf-8" />
                        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
                        <meta name="description" content="" />
                        <meta name="author" content="" />
                        <title>SOPORTE</title>
                        <link href="/public/css/style.min.css" rel="stylesheet" />
                        <link href="/public/css/styles.css" rel="stylesheet" />
                        <link href="/public/css/sistema.css" rel="stylesheet" />                   
                        <script src="/public/js/all.js" crossorigin="anonymous"></script>
                    </head>
                    <body class="d-flex align-items-center px-2 py-4 bg-body-tertiary">
                        <div class="container">
                            <main class="form-signin col-md-6 mx-auto">
                                <form id="formNewOrden" action="/contacto" method="post" onsubmit="return false;" enctype="multipart/form-data">
                                    <h1 class="h3 mb-3 fw-normal">Sistema ticket soporte Cliente</h1>                          
                                    <div class="form-floating mb-3">     
                                        <select class="form-select" id="TypeTicket" name="TypeTicket">
                                            <option value="bug critico">Error critico</option>
                                            <option value="bug uso">Error Uso NO CRITICO</option>
                                            <option value="mejora critica">Mejora Critica</option>
                                            <option value="mejora uso">Mejora NO CRITICA</option>
                                        </select>                                   
                                        <label for="TypeTicket">Tipo de soporte solicitado</label>
                                    </div>
                                    <label for="detalle">Detalle Problema :</label>
                                    <div class="form-floating mb-3">
                                        <textarea id="DetalleOrden" name="DetalleOrden" rows="4" class="form-control" style="resize: none; height: 120px"></textarea>
                                    </div>                                    
                                    <div class="mb-3">
                                        <button class="btn btn-primary w-100" type="button" id="enviar" onclick="enviarFormulario()">Enviar</button>
                                    </div>
                                    <div class="d-flex justify-content-around" id="botones">
                                        <div class="mb-2">
                                            <button class="btn btn-warning w-100" type="button" id="cancelar" onclick="cerrarFormulario()">Cancelar</button>
                                        </div>
                                        <div class="mb-2">
                                            <button class="btn btn-secondary w-100" type="button" id="resetear" onclick="resetearFormulario()">Resetear</button>
                                        </div>
                                    </div>
                                </form>
                            </main>
                        </div>
                        <dialog class="rounded border-1 border-success" id="miDialogo" show()>
                            <div id="ordenRespuesta"></div>
                            <button class="btn btn-primary" id="cerrarDialogo" onclick="cerrarDialogo()">Cerrar</button>
                        </dialog>

                        <script>
                            function enviarFormulario() {
                                document.getElementById('formNewOrden').submit();
                            }

                            function resetearFormulario() {
                                document.getElementById('formNewOrden').reset();
                            }

                            function cerrarFormulario() {
                                window.close();
                            }

                            function cerrarDialogo() {
                                // Lógica para cerrar el diálogo
                                document.getElementById('miDialogo').close();
                            }
                        </script>
                    </body>
                </html>

        HTML;
        return $html;
    }
}
