<?php

namespace src\views;

class HomeLogView
{
    /**
     * @data array de datos a mostrar
     */
    public function render($data = null)
    {
        if ($data) {
            extract($data);         
            extract($this->cantidadToData($contarOrdenes));
            // array de ordenes con nro y fecha
            $listOrdenes = $this->listOrdenes($contarOrdenes);
            //crea listas de ordenes para resumen
            $listaRecepcionada = $this->crearListaResumen($listOrdenes['recepcionada'], 'list-recepcionada');
            $listaProceso = $this->crearListaResumen($listOrdenes['proceso'], 'list-proceso');
            $listaEntrega = $this->crearListaResumen($listOrdenes['entrega'], 'list-entrega');
            $listaPendiente = $this->crearListaResumen($listOrdenes['pendiente'], 'list-pendiente');
        }
        $headerView = new HeaderView();
        $head = $headerView->render();
        // obtener navbar
        $navBarView = new NavBarView();
        $nav = $navBarView->render($titulo, false);
        // Obtener footer
        $footerView = new FooterView();
        $footer = $footerView->render();
        // obtener calendario
        $calendarView = new CalendarView();
        $calendar = $calendarView->render();       

        return <<<HTML
            $head
            <body class="sb-nav-fixed">                
                $nav
                <div id="layoutSidenav">                    
                    <div id="layoutSidenav_nav">
                        <nav class="sb-sidenav accordion sb-sidenav-dark mt-5 p-1 my-5" id="sidenavAccordion">
                            <div class="sb-sidenav-menu">
                                <div class="nav">
                                    $calendar
                                    <hr class="border border-secondary border-1 opacity-75">
                                    <div class="text-center text-light w-100 pt-1">
                                        <p class="h4">Ordenes</p>
                                    </div>
                                    <!-- ... Contenido de las órdenes ... -->
                                    <div class="mt-2">
                                        <!-- ... Contenido de órdenesPendientes ... -->
                                        <div class="btn btn-warning p-2 w-100 border rounded d-flex justify-content-between align-items-center"
                                            id="ordenesPendientes" onclick="togglePanel('#panel3')" type="button">
                                            Recepcionadas
                                            <span class="border  p-1 rounded bg-light text-warning">
                                                <i class="fas fa-bell "></i>
                                                $count_ordenes_recepcionada
                                            </span>
                                        </div>
                                        <div class="collapse multi-collapse mt-1" id="panel3">
                                            <div class="card card-body text-black">
                                                $listaRecepcionada
                                            </div>
                                        </div>
                                    </div>
                                    <div class="mt-2">
                                        <!-- ... Contenido de órdenesProceso ... -->
                                        <div class="btn btn-primary p-2 w-100 border rounded d-flex justify-content-between align-items-center"
                                            id="ordenesProceso" onclick="togglePanel('#panel2')" type="button">
                                            En Proceso
                                            <span class="border  p-1 rounded bg-light text-primary">
                                                <i class="fas fa-bell "></i>
                                                $count_ordenes_proceso
                                            </span>
                                        </div>
                                        <div class="collapse multi-collapse mt-1" id="panel2">
                                            <div class="card card-body text-black ">
                                                $listaProceso                                                
                                            </div>
                                        </div>
                                    </div>
                                    <div class="mt-2">
                                        <!-- ... Contenido de órdenesObservadas ... -->
                                        <div class="btn btn-danger p-2 w-100 border rounded d-flex justify-content-between align-items-center"
                                            id="ordenesObservadas" onclick="togglePanel('#panel4');" type="button">
                                            Pendientes
                                            <span class="border  p-1 rounded bg-light text-danger">
                                                <i class="fas fa-bell "></i>
                                                $count_ordenes_pendiente
                                            </span>
                                        </div>
                                        <div class="collapse multi-collapse mt-1" id="panel4">
                                            <div class="card card-body text-black">
                                                $listaPendiente
                                            </div>
                                        </div>
                                    </div>
                                    <div class="mt-2">
                                        <!-- ... Contenido de órdenesFinalizadas ... -->
                                        <div class="btn btn-success p-2 w-100 border rounded d-flex justify-content-between align-items-center"
                                            id="ordenesFinalizadas" onclick="togglePanel('#panel1')" type="button">
                                            Para Entrega
                                            <span class="border  p-1 rounded bg-light text-success">
                                                <i class="fas fa-bell "></i>
                                                $count_ordenes_entrega
                                            </span>
                                        </div>
                                        <div class="collapse multi-collapse mt-1" id="panel1">
                                            <div class="card card-body text-black ">
                                                $listaEntrega
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </nav>
                    </div>
                    <div id="layoutSidenav_content">
                        <main>                                                   
                            <!-- Contenedor Principal  -->
                            <div class="card m-2 position-sticky main "
                                >
                                <div class="card-header">
                                    <i class="fas fa-table me-1"></i> Versiones software
                                </div>
                                <div class="p-2">
                                    $updateLog
                                </div>    
                            </div>
                    </div>
                    </main>
                </div>
                </div>
                <dialog class="rounded border-1 bg-danger  border-warning" id="miDialogo" show()>
                    <div id="dialogMsg"></div>
                    <button class="btn btn-primary" id="cerrarDialogo">Cerrar</button>                        
                </dialog>
                    $footer
        HTML;       
    }
    private function tablaOrdenes($data)
    {
        //    debug($data,__line__,true);
        $fecha_actual = new \DateTime('now');
        $tabla_body = '';
        foreach ($data as  $orden) {            
            $fecha_orden = new \DateTime($orden["fecha_inicio"]);
            $diferencia = $fecha_actual->diff($fecha_orden);
            $tabla_body .= '             <tr>' . PHP_EOL;
            $tabla_body .= '                <td ><button class="ms-2 btn btn-primary" href="#" onclick="verOrden(' . $orden["id_orden"] . ');"># ' . $orden["id_orden"]  . '</button></td>' . PHP_EOL;
            $tabla_body .= '                <td ><button class="ms-2 btn btn-primary" name="print" id="print-' . $orden["id_orden"] . '"><i class=" printer-icon  icon "></i>Imprimir</button></td>' . PHP_EOL;
            $tabla_body .= '                <td>'  . $orden["nombre"] . '</td>' . PHP_EOL;
            $tabla_body .= '                <td><a href="https://wa.me/' . $orden["telefono"] . '?text=Mensaje%20desde%20{{TITULO}}%20,%20la%20orden%20Nro:%20' . $orden["id_orden"] . '%20esta%20 ' . $orden["nombre_estado"] . '" target="_blank"><i class="fab fa-whatsapp text-success"></i>' . $orden["telefono"] . '</a></td>' . PHP_EOL;
            $tabla_body .= '                <td class="align-items-center"><p class=" py-2 bg-info text-center  p-1 border rounded d-flex justify-content-center align-items-center ">' . $diferencia->days . ' Dias</p></td>' . PHP_EOL;
            $tabla_body .= '                <td><a href="#" onclick="verOrden(' . $orden["id_orden"] . ');" class="btn-hover py-2 text-center text-light p-1 w-100 border rounded d-flex justify-content-center align-items-center ' . lcfirst($orden["nombre_estado"]) . '"><i class="ms-3 ' . lcfirst($orden["nombre_estado"]) . '-icon icon"></i>' . $orden["nombre_estado"] . '</a></td>' . PHP_EOL;            
            $tabla_body .= '                <td>'  . $orden["detalle"] . '</td>' . PHP_EOL;            
            $tabla_body .= '             </tr>' . PHP_EOL;
        }

        return $tabla_body;
    }
    private function cantidadToData($countOrdenes)
    {
        $data = [];
        foreach ($countOrdenes as $value) {
            $data['count_ordenes_' . (lcfirst($value['nombre_estado']))] = $value['cantidad_ordenes'];
        }
        return $data;
    }
    private function listOrdenes($countOrdenes)
    {
        $data = [];
        $ordenes[] = '';
        foreach ($countOrdenes as $value) {
            $data[lcfirst($value['nombre_estado'])]['lista_ordenes'] = explode(',', $value['lista_ordenes']);
            $data[lcfirst($value['nombre_estado'])]['fecha_ordenes'] = explode(',', $value['fecha_ordenes']);
        }
        foreach ($data as $key => $value) {
            $ordenes[$key] = array_combine($value['lista_ordenes'], $value['fecha_ordenes']);
        }
        return ($ordenes);
    }

    private function crearListaResumen($ordenes, $class)
    {
        $fecha_actual = new \DateTime('now');
        $html = '<ul class="list-unstyled ordenList">' . PHP_EOL;
        foreach ($ordenes as $key => $value) {
            $fecha_orden = new \DateTime($value);
            $diferencia = $fecha_actual->diff($fecha_orden);

            //   $html .= '                  <li><button type="button" class="small  stretched-link ' . $class . '"  onclick="verOrden(' . $key . ');" > Orden -' . $key . ' - ' . $diferencia->days . ' Dias </button></li>' . PHP_EOL;
            //    $html .= '                  <li><a class="small  stretched-link '.$class.'" href="orden/id/' . $key . '">Orden -' . $key . ' - ' . $diferencia->days . ' Dias </a></li>' . PHP_EOL;
            // $html .= '<li><button type="button" onclick="verOrden(10);"> 10 </button></li>' . PHP_EOL;
            $html .= ' <li><a  href="#" onclick="verOrden(' . $key . ');event.preventDefault();"> Orden -' . $key . ' - ' . $diferencia->days . ' Dias </a></li>' . PHP_EOL;
            // $html .= '<li><button type="button" onclick="verOrden(4);"> 4 </button></li>' . PHP_EOL;
        }
        $html .= "</ul>" . PHP_EOL;
        return $html;
    }
}
