<?php

namespace src\views;

class NavBarView
{
    public function render($titulo, $typeUser = null)
    {
        $menuType = $typeUser ? $typeUser : 'General';
        // Llamar al método de menú según el tipo de usuario
        $nav = $this->callMenuMethod($menuType);
        return $nav;
    }

    private function callMenuMethod($menuType)
    {
        $methodName = "menu" . $menuType;
        if (method_exists($this, $methodName)) {
            // Llamar al método de menú según el tipo de usuario
            return $this->{$methodName}();
        } else {
            // Manejar el caso en el que no exista un menú específico para el tipo de usuario
            return '<div>Menú no disponible</div>';
        }
    }


    /**
     * menu default
     * @param string $titulo
     */
    public function menuGeneral($titulo = false)
    {
        $version=CONFIG_APP ['appVersion'];
        $appRemoteVersion=CONFIG_APP ['appRemoteVersion'];
        $titulo = $titulo ? $titulo : CONFIG_APP['titulo'];
        $actualizar = <<<ACTUALIZAR
            <ul class="navbar-nav px-5">
                <li class="">
                    <!--span class="btn btn-success" > Tiene la ultima version ($version)</span-->
                    <a class="nav-link btn btn-success" href="../home/updateLog" target="_blank">Ver log de version  actual ( $version )</a>
                </li>
            </ul>
        ACTUALIZAR;        
        if (CONFIG_APP['updateVerify']) {
            $actualizar = <<<ACTUALIZAR
                    <ul class="navbar-nav px-5">
                        <li class="nav-item">
                            <a class="nav-link btn btn-warning" href="actualizar" target="_blank">Existe una version nueva  (Ver: $appRemoteVersion )</a>
                        </li>
                    </ul>
            ACTUALIZAR;
        }
        return <<<HTML
                    <!-- <nav class="sb-topnav navbar navbar-dark bg-dark d-flex justify-content-between"> -->
                    <nav class="sb-topnav navbar navbar-expand navbar-dark bg-dark d-flex">
                    <div class="container-fluid d-flex">
                    <div class="flex-grow-1 d-none d-lg-block">
                            <a class="navbar-brand ps-3" href="/">$titulo</a>
                        </div>
                        <div class="flex-grow-1 text-center">
                            <ul class="navbar-nav">                                
                                <li class="nav-item">
                                    <a class="btn btn-secondary nav-link mx-2" href="cliente">Clientes</a>
                                </li>
                                <li class="nav-item">
                                    <a class="btn btn-secondary nav-link mx-2" href="/">Ordenes</a>
                                </li>
                                <li class="nav-item">
                                    <a class="btn btn-secondary nav-link mx-2" href="/orden/list"> Listado Ordenes</a>
                                </li>
                                <li class="nav-item">
                                    <a class="btn btn-secondary nav-link mx-2" href="#" onclick="newContact(); return false;">Contacto</a>
                                </li>
                            </ul>
                        </div>
                        <div class="ms-auto d-flex align-items-center">
                            $actualizar
                            <button class="btn btn-link btn-sm order-1 order-lg-0 me-4 me-lg-0 bg-secondary"  style="" id="sidebarToggle" href="#!">
                                <i class="fas fa-bars text-white"></i>
                            </button>
                        </div>
                    </div>
                </nav>
        HTML;        
    }

    public function menuGeneral2($titulo = false)
    {
        $titulo = $titulo ? $titulo : CONFIG_APP['titulo'];
        $menu = <<<HTML
                    <nav class="sb-topnav navbar navbar-expand navbar-dark bg-dark d-flex">
                    <a class="navbar-brand ps-3" href="index.html">$titulo</a>
                    <div class="ms-auto d-md-block">
                        <ul class="navbar-nav">
                            <li>
                                <button class="btn btn-link btn-sm order-1 order-lg-0 me-4 me-lg-0" id="sidebarToggle" href="#!">Home</button>
                            </li>    
                            <li>
                                <button class="btn btn-link btn-sm order-1 order-lg-0 me-4 me-lg-0" id="sidebarToggle" href="#!">
                                    <i class="fas fa-bars text-white"></i>
                                </button>
                            </li>
                        </ul>
                    </div>
                </nav>
        HTML;
        return $menu;
    }
}
