<?php

namespace src\views;

class NuevaOrdenView
{
    public function render($data = null)
    {
        // debug($data,__LINE__,true);
        extract($data);
        extract($cliente);
        //debug($marcas,__LINE__,true);

        $titulo = '';
        $marcasSelect = $this->marcasSelect($marcas);

        $html = <<<HTML
                <!DOCTYPE html>
                <html lang="es">
                <head>
                    <meta charset="utf-8" />
                    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
                    <meta name="description" content="" />
                    <meta name="author" content="" />
                    <title>$titulo</title>
                    <link href="/public/css/style.min.css" rel="stylesheet" />
                    <link href="/public/css/styles.css" rel="stylesheet" />
                    <link href="/public/css/sistema.css" rel="stylesheet" />                   
                    <script src="/public/js/all.js" crossorigin="anonymous"></script>
                </head>
                <body class="d-flex align-items-center px-2 py-4 bg-body-tertiary">
                    <div class="container">
                        <main class="form-signin col-md-6 mx-auto" id="mainOrder">
                            <form id="formNewOrden" action="" method="post" onsubmit="return false;" enctype="multipart/form-data">
                                <h1 class="h3 mb-3 fw-normal">Nueva Orden de Reparacion</h1>
                                <input class="form-control" id="IdCliente" placeholder="Id_Cliente" name="IdCliente" hidden value="$id_cliente">
                                <div class="form-floating mb-3">
                                    <h5>Cliente</h5>                                    
                                    <p>$id_cliente:    $nombre Telefono: $telefono </p>
                                    <p>$email</p>
                                </div>
                                <div class="form-floating mb-3">
                                    $marcasSelect
                                    <!-- <input type="text" class="form-control" id="MarcaEquipo" placeholder="Marca Equipo" name="MarcaEquipo"> -->
                                    <label for="MarcaEquipo">Marca Equipo</label>
                                </div>
                                <div class="form-floating mb-3">                                    
                                    <input type="text" class="form-control" id="ModeloEquipo" placeholder="Modelo Equipo" name="ModeloEquipo">
                                    <label for="ModeloEquipo">Modelo Equipo</label>
                                </div>
                                <label for="detalle">Detalle Problema :</label>
                                <div class="form-floating mb-3">
                                    <textarea id="DetalleOrden" name="DetalleOrden" rows="4" class="form-control"  style="resize: none; height: 120px" required></textarea>
                                </div>
                                
                                <div class="mb-3">
                                    <button class="btn btn-primary w-100" type="submit" id="enviar">Crear Orden</button>
                                </div>
                                <!-- <div class="mb-3" id="botones"> -->
                                <div class=" d-flex justify-content-around" id="botones">
                                    <div class="mb-2">
                                        <button class="btn btn-warning w-100" type="button" id="cancelar">Cancelar Orden</button>
                                    </div>
                                    <div class="mb-2">
                                        <button class="btn btn-secondary w-100" type="button" id="resetear">Resetear Formulario</button>
                                    </div>
                                </div>
                            </form>
                        </main>
                    </div>
                    <dialog class="rounded border-1 border-success" id="miDialogo">
                        <div id="ordenMsg"></div>
                        <button class="btn btn-primary" id="cerrarDialogo">Cerrar</button>
                    </dialog>

                    <script>
                        document.getElementById('formNewOrden').addEventListener('submit', function(event) {
                            event.preventDefault(); // Evita que el formulario se envíe de forma convencional

                            // Capturar los valores del formulario
                            var formData = new FormData(this);
                            var formDataObject = {};
                            formData.forEach(function(value, key) {
                                formDataObject[key] = value;
                            });

                            console.log(JSON.stringify(formDataObject));

                            // Realizar la solicitud con fetch
                            fetch('/orden/nueva', {
                                method: 'POST',
                                body: formData
                            })
                            .then(response => {
                                switch (response.status) {
                                case (201):
                                    // Código 201 OK: La solicitud fue exitosa')
                                    console.log("Codigo " + response.status + " : La solicitud fue exitosa") // Código 201 OK: La solicitud fue exitosa
                                    const mainMsg = document.getElementById("mainOrder");
                                        const newMsg = '<div class="cliente-success"><span>Orden Creada con éxito</span></div>';
                                    mainMsg.innerHTML = newMsg;
                                    setTimeout(() => {
                                        window.close();
                                            if (window.opener && !window.opener.closed) {       
                                                    window.opener.location.reload();
                                                }
                                            }, 1000);
                                    return response.json();
                                case 404:
                                    // Código 404 Not Found: Recurso no encontrado
                                    throw new Error('Recurso no encontrado');
                                case 500:
                                    // Código 500 Internal Server Error: Error del servidor
                                    throw new Error('Error del servidor');
                                // Puedes agregar más casos según sea necesario
                                default:
                                    // Otros códigos de estado no manejados
                                    throw new Error('Error no manejado: ' + response.status);
                                }
                            })
                            .then(data => {
                                // Maneja los datos obtenidos
                                console.log(data);
                            })
                            .catch(error => {
                                // Maneja los errores
                                console.error('Error:', error);
                            });
                            
                        });

                    
                        document.getElementById('cancelar').addEventListener('click', function() {
                            window.close();
                        });

                    
                        document.getElementById('resetear').addEventListener('click', function() {
                    
                            console.log('Resetear');
                            document.getElementById('formNewOrden').reset(); 
                        });
                    </script>
                </body>
                </html>
        HTML;
        return $html;
    }
    private function marcasSelect($marcas)
    {
        $html = <<<HTML
                <select class="form-select" id="MarcaEquipo" name="MarcaEquipo">
            HTML;
        $html .= PHP_EOL;
        foreach ($marcas as $value) {
            extract($value);
            $html .= <<<HTML
                                                <option value="$id_marca">$marca</option>
            HTML;
            $html .= PHP_EOL;
        }
        $html .= "                            </select>" . PHP_EOL;
        return $html;
    }
}
