<?php
namespace src\views;

class NuevoClienteView
{
    /**
     * @data array de datos a mostrar
     */
    public function render($data = null)
    {
       
        $titulo = 'Nuevo Cliente';
        $html = <<<HTML
                <!DOCTYPE html>
                <html lang="es">
                <head>
                    <meta charset="utf-8" />
                    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
                    <meta name="description" content="" />
                    <meta name="author" content="" />
                    <title>$titulo</title>
                    <link href="/public/css/style.min.css" rel="stylesheet" />
                    <link href="/public/css/styles.css" rel="stylesheet" />
                    <link href="/public/css/sistema.css" rel="stylesheet" />                   
                    <script src="/public/js/all.js" crossorigin="anonymous"></script>
                    <script async src="/public/js/newCliente.js"></script>
                </head>
                <body class="d-flex align-items-center px-2 py-4 bg-body-tertiary">
                    <div class="container">
                        <main class="form-signin col-md-6 mx-auto" id="mainNewCliente">
                            <form id="formNewCliente" action=""  onsubmit="return false;"  method="post" enctype="multipart/form-data" >
                                <h1 class="h3 mb-3 fw-normal">Nuevo Cliente</h1>

                                <div class="form-floating mb-3">
                                    <input type="text" class="form-control" id="NombreCliente" placeholder="Nombre" name="NombreCliente" require>
                                    <label for="NombreCliente">Nombre Cliente</label>
                                </div>
                                <div class="form-floating mb-3">
                                    <input type="email" class="form-control" id="EmailCliente" placeholder="Email" name="EmailCliente" >
                                    <label for="EmailCliente">Email Cliente</label>
                                </div>
                                <div class="form-floating mb-3">
                                    <input type="number" class="form-control" id="TelefonoCliente" placeholder="Telefono Numero" name="TelefonoCliente" require>
                                    <label for="TelefonoCliente">Telefono Cliente (solo numeros)</label>
                                </div>
                                <!-- <div class="form-check form-check-inline mb-3">
                                    <input hidden name="EsWsp" value=false>
                                    <input class="form-check-input" type="checkbox" value=true id="EsWsp" name="EsWsp">
                                    <label class="form-check-label" for="EsWsp">Es WhatsApp ?</label>
                                </div> -->
                                <div class="mb-3">
                                    <button class="btn btn-primary w-100" type="submit" id="enviar">Enviar</button>
                                </div>
                                <!-- <div class="mb-3" id="botones"> -->
                                <div class=" d-flex justify-content-around" id="botones">
                                    <div class="mb-2">
                                        <button class="btn btn-warning w-100" type="button" id="cancelar">Cancelar </button>
                                    </div>
                                    <div class="mb-2">
                                        <button class="btn btn-secondary w-100" type="button" id="resetear">Borrar Form</button>
                                    </div>
                                </div>
                            </form>
                        </main>
                    </div>
                    <dialog class="alert-nuevo-cliente" id="alertNuevoCliente" show()>
                        <div id="ordenRespuesta"></div>
                        <button class="btn btn-primary w-100 p-2 mt-5" id="cerrarDialogo">Cerrar</button>
                    </dialog>                    
                </body>
                </html>
        HTML;
        return $html;
    }
}
