<?php

namespace src\views;

class OrdenView
{
    public function render($data = null)
    {
        // Variables de vista
        $titulo = CONFIG_APP['titulo'];
        // Lógica de presentación del view
        $html = <<<HTML
            <!DOCTYPE html>
            <html lang="es">
            <head>
                <meta charset="utf-8" />
                <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
                <meta name="description" content="" />
                <meta name="author" content="" />
                <title>{{TITULO}}</title>
                <link href="../public/css/style.min.css" rel="stylesheet" />
                <link href="../public/css/styles.css" rel="stylesheet" />
                <link href="../public/css/sistema.css" rel="stylesheet" />
                <link href="../public/css/calendar.css" rel="stylesheet" />
                <script src="../public/js/all.js" crossorigin="anonymous"></script>
            </head>
            <body class="sb-nav-fixed">
                <nav class="sb-topnav navbar navbar-expand navbar-dark bg-dark d-flex">
                    <a class="navbar-brand ps-3" href="index.html">{{TITULO}}</a>
                    <div class="ms-auto d-md-block">
                        <ul class="navbar-nav">
                            <li>
                                <button class="btn btn-link btn-sm order-1 order-lg-0 me-4 me-lg-0" id="sidebarToggle" href="#!">
                                    <i class="fas fa-bars text-white"></i>
                                </button>
                            </li>
                        </ul>
                    </div>
                </nav>
                <div id="layoutSidenav">
                    <div id="layoutSidenav_nav">
                        <nav class="sb-sidenav accordion sb-sidenav-dark mt-5 p-1 my-5" id="sidenavAccordion">
                            <div class="sb-sidenav-menu">
                                <div class="nav">
                                    <div id="calendario">
                                        <!-- ... Contenido del calendario ... -->
                                        <div id="fechaactual"><i onclick="actualizar()"></i></div>
                                        <div id="anterior" onclick="mesantes()"></div>
                                        <div id="posterior" onclick="mesdespues()"></div>
                                        <p id="titulos"></p>
                                        <table id="diasc">
                                            <tr id="fila0">
                                                <th></th>
                                                <th></th>
                                                <th></th>
                                                <th></th>
                                                <th></th>
                                                <th></th>
                                                <th></th>
                                            </tr>
                                            <tr id="fila1">
                                                <td></td>
                                                <td></td>
                                                <td></td>
                                                <td></td>
                                                <td></td>
                                                <td></td>
                                                <td></td>
                                            </tr>
                                            <tr id="fila2">
                                                <td></td>
                                                <td></td>
                                                <td></td>
                                                <td></td>
                                                <td></td>
                                                <td></td>
                                                <td></td>
                                            </tr>
                                            <tr id="fila3">
                                                <td></td>
                                                <td></td>
                                                <td></td>
                                                <td></td>
                                                <td></td>
                                                <td></td>
                                                <td></td>
                                            </tr>
                                            <tr id="fila4">
                                                <td></td>
                                                <td></td>
                                                <td></td>
                                                <td></td>
                                                <td></td>
                                                <td></td>
                                                <td></td>
                                            </tr>
                                            <tr id="fila5">
                                                <td></td>
                                                <td></td>
                                                <td></td>
                                                <td></td>
                                                <td></td>
                                                <td></td>
                                                <td></td>
                                            </tr>
                                            <tr id="fila6">
                                                <td></td>
                                                <td></td>
                                                <td></td>
                                                <td></td>
                                                <td></td>
                                                <td></td>
                                                <td></td>
                                            </tr>
                                        </table>
                                    </div>
                                    <hr class="border border-secondary border-1 opacity-75">
                                    <div class="text-center text-light w-100 pt-1">
                                        <p class="h3">Ordenes</p>
                                    </div>
                                    <!-- ... Contenido de las órdenes ... -->
                                    <div class="mt-2">
                                        <!-- ... Contenido de órdenesPendientes ... -->
                                        <div class="btn btn-warning p-2 w-100 border rounded d-flex justify-content-between align-items-center"
                                            id="ordenesPendientes" onclick="togglePanel('#panel3')" type="button">
                                            Recepcionadas
                                            <span class="border  p-1 rounded bg-light text-warning">
                                                <i class="fas fa-bell "></i>
                                                {{COUNT_RECIBIDAS}}
                                            </span>
                                        </div>
                                        <div class="collapse multi-collapse mt-1" id="panel3">
                                            <div class="card card-body text-black">
                                                {{LISTA_RECIBIDAS}}
                                                <!-- <ul class="list-unstyled">
                                                    <li><a class="small text-warning stretched-link" href="#">Orden -1</a>
                                                    </li>
                                                    <li><a class="small text-warning stretched-link" href="#">Orden -9</a>
                                                    </li>
                                                    <li><a class="small text-warning stretched-link" href="#">Orden -25</a>
                                                    </li>
                                                </ul> -->
                                            </div>
                                        </div>
                                    </div>
                                    <div class="mt-2">
                                        <!-- ... Contenido de órdenesProceso ... -->
                                        <div class="btn btn-primary p-2 w-100 border rounded d-flex justify-content-between align-items-center"
                                            id="ordenesProceso" onclick="togglePanel('#panel2')" type="button">
                                            En Proceso
                                            <span class="border  p-1 rounded bg-light text-primary">
                                                <i class="fas fa-bell "></i>
                                                {{COUNT_PROCESO}}
                                            </span>
                                        </div>
                                        <div class="collapse multi-collapse mt-1" id="panel2">
                                            <div class="card card-body text-black ">
                                                {{LISTA_PROCESO}}
                                                <!-- <ul class="list-unstyled">
                                                    <li><a class="small text-primary stretched-link" href="#">Orden -1</a>
                                                    </li>
                                                    <li><a class="small text-primary stretched-link" href="#">Orden -9</a>
                                                    </li>
                                                    <li><a class="small text-primary stretched-link" href="#">Orden -25</a>
                                                    </li>
                                                </ul> -->
                                            </div>
                                        </div>
                                    </div>
                                    <div class="mt-2">
                                        <!-- ... Contenido de órdenesObservadas ... -->
                                        <div class="btn btn-danger p-2 w-100 border rounded d-flex justify-content-between align-items-center"
                                            id="ordenesObservadas" onclick="togglePanel('#panel4');" type="button">
                                            Pendientes
                                            <span class="border  p-1 rounded bg-light text-danger">
                                                <i class="fas fa-bell "></i>
                                                {{COUNT_PENDIENTE}}
                                            </span>
                                        </div>
                                        <div class="collapse multi-collapse mt-1" id="panel4">
                                            <div class="card card-body text-black">
                                                {{LISTA_PENDIENTE}}                                  
                                                <!-- <ul class="list-unstyled"> -->
                                                    <!-- <li><a class="small text-danger stretched-link" href="#">Orden -1</a>
                                                    </li>
                                                    <li><a class="small text-danger stretched-link" href="#">Orden -9</a>
                                                    </li>
                                                    <li><a class="small text-danger stretched-link" href="#">Orden -25</a>
                                                    </li> -->
                                                <!-- </ul> -->
                                            </div>
                                        </div>
                                    </div>
                                    <div class="mt-2">
                                        <!-- ... Contenido de órdenesFinalizadas ... -->
                                        <div class="btn btn-success p-2 w-100 border rounded d-flex justify-content-between align-items-center"
                                            id="ordenesFinalizadas" onclick="togglePanel('#panel1')" type="button">
                                            Para Entrega
                                            <span class="border  p-1 rounded bg-light text-success">
                                                <i class="fas fa-bell "></i>
                                                {{COUNT_FINALIZADAS}}
                                            </span>
                                        </div>
                                        <div class="collapse multi-collapse mt-1" id="panel1">
                                            <div class="card card-body text-black">
                                            {{LISTA_PENDIENTE}}
                                                <!-- <ul class="list-unstyled">
                                                    <li><a class="small text-success stretched-link" href="#">Orden -1
                                                            (2024-01-10) </a></li>
                                                    <li><a class="small text-success stretched-link" href="#">Orden -9
                                                            (2024-01-14)</a></li>
                                                    <li><a class="small text-success stretched-link" href="#">Orden -25
                                                            (2024-01-15)</a></li>
                                                </ul> -->
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </nav>
                    </div>
                    <div id="layoutSidenav_content">
                        <main>
                            <div class="container mt-4">
                                <!-- Botones acceso sistema -->
                                <div class="row position-sticky " style="top:60px; z-index: 1005; background-color: #ffffff;">
                                    <!-- ... Contenido de botones ... -->
                                    <div class="col-xl-4 col-md-6">
                                        <div class="card bg-primary text-white py-3 mb-4 text-center" type="button"
                                            onclick="newOrden()">
                                            Nueva Orden
                                        </div>
                                    </div>
                                    <div class="col-xl-4 col-md-6">
                                        <div class="card bg-primary text-white py-3 mb-4 text-center" type="button"
                                            onclick="newCliente()">
                                            Nuevo Cliente
                                        </div>
                                    </div>
                                    <div class="col-xl-4 col-md-6">
                                        <div class="card bg-primary text-white py-3 mb-4 text-center" type="button"
                                            onclick="newMaterial()">
                                            Nuevo Material
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- Contenedor Principal  -->
                            <div class="card m-5 position-sticky "
                                style="top:370px; z-index: 1000; background-color: #fafafa;">
                                <div class="card-header">
                                    <i class="fas fa-table me-1"></i> Ordenes Reparacion
                                </div>
                                <table id="tablaOrdenes" class="mx-auto table-striped">
                                    <!-- ... Contenido de la tabla de órdenes ... -->
                                    <thead>
                                        <tr>
                                            <th>Nro Orden</th>
                                            <th>Cliente</th>
                                            <th>Telefono</th>
                                            <th>Dias de Ingreso</th>
                                            <th>Estado</th>
                                            <th>Problema</th>
                                            <th>Comentario</th>
                                        </tr>
                                    </thead>
                                    <tfoot>
                                        <tr>
                                            <th>Nro Orden</th>
                                            <th>Cliente</th>
                                            <th>Telefono</th>
                                            <th>Dias de Ingreso</th>
                                            <th>Estado</th>
                                            <th>Problema</th>
                                            <th>Comentario</th>
                                        </tr>
                                    </tfoot>
                                    <tbody>
                                        <tr>
                                            <td># 1</td>
                                            <td>Fermin</td>
                                            <td><a href="https://wa.me/+34665903187?text=Mensaje%20desde%20{{TITULO}}%20,%20la%20orden%20Nro:%201%20esta%20 Recepcionada"
                                                    target="_blank"><i class="fab fa-whatsapp text-success"></i>+34665903187</a>
                                            </td>
                                            <td>
                                                <p
                                                    class="btn bg-info text-center  btn p-1 w-100 border rounded d-flex justify-content-center align-items-center ">
                                                    22 Dias</p>
                                            </td>
                                            <td>
                                                <p
                                                    class="btn text-center text-light btn p-1 w-100 border rounded d-flex justify-content-center align-items-center recepcionada">
                                                    Recepcionada</p>
                                            </td>
                                            <td>Pantalla rota, disco no reconocido. Teclado con faltante de teclas</td>
                                            <td>Comentario1</td>
                                        </tr>
                                        <tr>
                                            <td># 2</td>
                                            <td>Pedro ALbarracin</td>
                                            <td><a href="https://wa.me/987654321?text=Mensaje%20desde%20{{TITULO}}%20,%20la%20orden%20Nro:%202%20esta%20 Proceso"
                                                    target="_blank"><i class="fab fa-whatsapp text-success"></i>987654321</a></td>
                                            <td>
                                                <p
                                                    class="btn bg-info text-center  btn p-1 w-100 border rounded d-flex justify-content-center align-items-center ">
                                                    21 Dias</p>
                                            </td>
                                            <td>
                                                <p
                                                    class="btn text-center text-light btn p-1 w-100 border rounded d-flex justify-content-center align-items-center proceso">
                                                    Proceso</p>
                                            </td>
                                            <td>Detalle2</td>
                                            <td>Comentario2</td>
                                        </tr>
                                        <tr>
                                            <td># 3</td>
                                            <td>Marcelo Perez Oriellano</td>
                                            <td><a href="https://wa.me/111223344?text=Mensaje%20desde%20{{TITULO}}%20,%20la%20orden%20Nro:%203%20esta%20 Entrega"
                                                    target="_blank"><i class="fab fa-whatsapp text-success"></i>111223344</a></td>
                                            <td>
                                                <p
                                                    class="btn bg-info text-center  btn p-1 w-100 border rounded d-flex justify-content-center align-items-center ">
                                                    20 Dias</p>
                                            </td>
                                            <td>
                                                <p
                                                    class="btn text-center text-light btn p-1 w-100 border rounded d-flex justify-content-center align-items-center entrega">
                                                    Entrega</p>
                                            </td>
                                            <td>Detalle3</td>
                                            <td>Comentario3</td>
                                        </tr>
                                        <tr>
                                            <td># 4</td>
                                            <td>Marcelo Perez Oriellano</td>
                                            <td><a href="https://wa.me/111223344?text=Mensaje%20desde%20{{TITULO}}%20,%20la%20orden%20Nro:%204%20esta%20 Pendiente"
                                                    target="_blank"><i class="fab fa-whatsapp text-success"></i>111223344</a></td>
                                            <td>
                                                <p
                                                    class="btn bg-info text-center  btn p-1 w-100 border rounded d-flex justify-content-center align-items-center ">
                                                    18 Dias</p>
                                            </td>
                                            <td>
                                                <p
                                                    class="btn text-center text-light btn p-1 w-100 border rounded d-flex justify-content-center align-items-center pendiente">
                                                    Pendiente</p>
                                            </td>
                                            <td>Detalle3</td>
                                            <td>Comentario3</td>
                                        </tr>
                                        <tr>
                                            <td># 5</td>
                                            <td>Fermin</td>
                                            <td><a href="https://wa.me/+34665903187?text=Mensaje%20desde%20{{TITULO}}%20,%20la%20orden%20Nro:%205%20esta%20 Recepcionada"
                                                    target="_blank"><i class="fab fa-whatsapp text-success"></i>+34665903187</a>
                                            </td>
                                            <td>
                                                <p
                                                    class="btn bg-info text-center  btn p-1 w-100 border rounded d-flex justify-content-center align-items-center ">
                                                    18 Dias</p>
                                            </td>
                                            <td>
                                                <p
                                                    class="btn text-center text-light btn p-1 w-100 border rounded d-flex justify-content-center align-items-center recepcionada">
                                                    Recepcionada</p>
                                            </td>
                                            <td>Detalle1</td>
                                            <td>Comentario1</td>
                                        </tr>
                                        <tr>
                                            <td># 6</td>
                                            <td>Pedro ALbarracin</td>
                                            <td><a href="https://wa.me/987654321?text=Mensaje%20desde%20{{TITULO}}%20,%20la%20orden%20Nro:%206%20esta%20 Proceso"
                                                    target="_blank"><i class="fab fa-whatsapp text-success"></i>987654321</a></td>
                                            <td>
                                                <p
                                                    class="btn bg-info text-center  btn p-1 w-100 border rounded d-flex justify-content-center align-items-center ">
                                                    17 Dias</p>
                                            </td>
                                            <td>
                                                <p
                                                    class="btn text-center text-light btn p-1 w-100 border rounded d-flex justify-content-center align-items-center proceso">
                                                    Proceso</p>
                                            </td>
                                            <td>Detalle2</td>
                                            <td>Comentario2</td>
                                        </tr>
                                        <tr>
                                            <td># 7</td>
                                            <td>Marcelo Perez Oriellano</td>
                                            <td><a href="https://wa.me/111223344?text=Mensaje%20desde%20{{TITULO}}%20,%20la%20orden%20Nro:%207%20esta%20 Entrega"
                                                    target="_blank"><i class="fab fa-whatsapp text-success"></i>111223344</a></td>
                                            <td>
                                                <p
                                                    class="btn bg-info text-center  btn p-1 w-100 border rounded d-flex justify-content-center align-items-center ">
                                                    15 Dias</p>
                                            </td>
                                            <td>
                                                <p
                                                    class="btn text-center text-light btn p-1 w-100 border rounded d-flex justify-content-center align-items-center entrega">
                                                    Entrega</p>
                                            </td>
                                            <td>Detalle3</td>
                                            <td>Comentario3</td>
                                        </tr>
                                        <tr>
                                            <td># 8</td>
                                            <td>Marcelo Perez Oriellano</td>
                                            <td><a href="https://wa.me/111223344?text=Mensaje%20desde%20{{TITULO}}%20,%20la%20orden%20Nro:%208%20esta%20 Pendiente"
                                                    target="_blank"><i class="fab fa-whatsapp text-success"></i>111223344</a></td>
                                            <td>
                                                <p
                                                    class="btn bg-info text-center  btn p-1 w-100 border rounded d-flex justify-content-center align-items-center ">
                                                    15 Dias</p>
                                            </td>
                                            <td>
                                                <p
                                                    class="btn text-center text-light btn p-1 w-100 border rounded d-flex justify-content-center align-items-center pendiente">
                                                    Pendiente</p>
                                            </td>
                                            <td>Detalle3</td>
                                            <td>Comentario3</td>
                                        </tr>
                                        <tr>
                                            <td># 9</td>
                                            <td>Marcelo Perez Oriellano</td>
                                            <td><a href="https://wa.me/111223344?text=Mensaje%20desde%20{{TITULO}}%20,%20la%20orden%20Nro:%209%20esta%20 Pendiente"
                                                    target="_blank"><i class="fab fa-whatsapp text-success"></i>111223344</a></td>
                                            <td>
                                                <p
                                                    class="btn bg-info text-center  btn p-1 w-100 border rounded d-flex justify-content-center align-items-center ">
                                                    15 Dias</p>
                                            </td>
                                            <td>
                                                <p
                                                    class="btn text-center text-light btn p-1 w-100 border rounded d-flex justify-content-center align-items-center pendiente">
                                                    Pendiente</p>
                                            </td>
                                            <td>Detalle3</td>
                                            <td>Comentario3</td>
                                        </tr>
                                        <tr>
                                            <td># 10</td>
                                            <td>Jorge Alberto Marcico</td>
                                            <td><a href="https://wa.me/11122335?text=Mensaje%20desde%20{{TITULO}}%20,%20la%20orden%20Nro:%2010%20esta%20 Pendiente"
                                                    target="_blank"><i class="fab fa-whatsapp text-success"></i>11122335</a></td>
                                            <td>
                                                <p
                                                    class="btn bg-info text-center  btn p-1 w-100 border rounded d-flex justify-content-center align-items-center ">
                                                    14 Dias</p>
                                            </td>
                                            <td>
                                                <p
                                                    class="btn text-center text-light btn p-1 w-100 border rounded d-flex justify-content-center align-items-center pendiente">
                                                    Pendiente</p>
                                            </td>
                                            <td>Detalle3</td>
                                            <td>Comentario3</td>
                                        </tr>
                                </table>
                                <!-- Paginación de Órdenes -->
                            </div>
                    </div>
                    </main>
                </div>
                </div>
                <script src="../public/js/bootstrap.bundle.min.js"></script>
                <script src="../public/js/scripts.js"></script>
                <script src="../public/js/calendar.js"></script>
                <script src="../public/js/simple-datatables.min.js"></script>
                <script src="../public/js/tabla_clientes.js"></script>
            </body>
        </html>
        HTML;
        return  $html;
    }
}
