<?php
// verificacion de version y tiempo de update
function getUrl($url)
{
    $remoteData = file_get_contents($url);
    //  $result= $version_remote > CONFIG_APP['appVersion']? 'true':'false';
    return $remoteData;
}
function verifyVersion()
{
    $version_remote = file_get_contents(CONFIG_APP['urlVersion']);
    //  $result= $version_remote > CONFIG_APP['appVersion']? 'true':'false';
    return $version_remote;
}
function verifyTimeUpdate()
{
    $updateValid = (time() > CONFIG_APP['timeUpdate']+CONFIG_APP['lapsUpdate']);
    return $updateValid;
}
function actualizaVersion($rutaArchivo, $version)
{
    $jsonContent = file_get_contents($rutaArchivo);
    $configArray = json_decode($jsonContent, true);
    $configArray['appVersion'] = $version;
    $configArray['timeVerify'] = substr(time(), 0, 7);
    $newJsonContent = json_encode($configArray);
    file_put_contents($rutaArchivo, $newJsonContent);
}
function actualizaTime($rutaArchivo)
{
    $jsonContent = file_get_contents($rutaArchivo);
    $configArray = json_decode($jsonContent, true);
    $configArray['timeUpdate'] = time() + CONFIG_APP['lapsUpdate'];
    // verifica si existe archivo update
    $configArray['updateVerify'] = file_exists(CONFIG_APP['dirUpdate'] . CONFIG_APP['appRemoteVersion'] . CONFIG_APP['fileUpdate']);
    $newJsonContent = json_encode($configArray);
    file_put_contents($rutaArchivo, $newJsonContent);
}
function actualizaJson($rutaArchivo,$key,$value){
    $arrayFile=  json_decode(file_get_contents($rutaArchivo), true);
    $arrayFile[$key]=$value;
    $json=json_encode($arrayFile);
    file_put_contents($rutaArchivo,$json);
}
function verifyFile($file)
{
    return file_exists($file);
}
function  getRemoteUpdate()
{
    set_time_limit(0);
    // Configuración de la petición cURL
    $ch = curl_init(CONFIG_APP['urlDev']);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HEADER, true);
    // Configuracion headers, version  y token
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Authorization: Bearer ' . CONFIG_APP['appToken'],
        'Version: ' . CONFIG_APP['appVersion'],
    ]);
    // tiempo espera  indefinido
    curl_setopt($ch, CURLOPT_TIMEOUT, 0);
    // Ejecutar la petición cURL
    $response = curl_exec($ch);
    // Verificar si hay errores
    if (curl_errno($ch)) {
        echo 'Error en la petición cURL: ' . curl_error($ch);
    }

    // Obtener el tamaño del encabezado
    $header_size = curl_getinfo($ch, CURLINFO_HEADER_SIZE);
    // Separar encabezados y cuerpo
    $header = substr($response, 0, $header_size);
    $body = substr($response, $header_size);
    // Obtener el Content-Type del encabezado
    $contentType = curl_getinfo($ch, CURLINFO_CONTENT_TYPE);
    // Cerrar la sesión cURL
    curl_close($ch);
    // Verificar el Content-Type para determinar si es un archivo ZIP
    if (strpos($contentType, 'application/zip') !== false) {
        // Es un archivo ZIP, puedes guardar el cuerpo en un archivo
        file_put_contents(CONFIG_APP['dirUpdate'] . CONFIG_APP['appRemoteVersion'] . CONFIG_APP['fileUpdate'], $body);
        if (file_exists(CONFIG_APP['dirUpdate'] . CONFIG_APP['appRemoteVersion'] . CONFIG_APP['fileUpdate'])) {
            return true;
        } else {

            return false;
        }
    } else {
        echo 'El contenido no es un archivo ZIP.';
        echo '<script>alert("El contenido no es un archivo valido");</script>';
        return false;
    }
    echo '<script>alert(' . __FILE__ . '" Updtae exitoso");</script>';
    return true;
}
function debug($data, $line = null, $exit = false)
{
    // Si la constante 'DEV' es verdadera, imprime información de depuración.
    if (CONFIG_APP['envDev']) {
        echo '<pre>';
        // Imprime la línea actual.
        print_r('Info: ' . $line);
        echo PHP_EOL;

        // Imprime la información de depuración.
        print_r($data);
        echo '</pre>';
        if ($exit) exit('Exit');
    }
}
function config()
{
    // Ruta al archivo JSON de configuración
    $jsonFilePath = './config.json';
    // Verifica si el archivo existe
    if (file_exists($jsonFilePath)) {
        // Lee el contenido del archivo JSON
        $jsonContent = file_get_contents($jsonFilePath);
        // Decodifica el JSON a un array asociativo
        $configArray = json_decode($jsonContent, true);
        $versionArray = json_decode(file_get_contents('./config_app.json'), true);
        foreach ($versionArray as $key => $value) {
            $configArray['appEnv'][$key] = $value;
        }
        // Define las constantes CONFIG_APP y CONFIG_DB
        if (!defined('CONFIG_APP')) {
            define('CONFIG_APP', $configArray['appEnv']);
        }
        if (!defined('CONFIG_DB')) {
            define('CONFIG_DB', ($_SERVER['SERVER_NAME'] === CONFIG_APP['serverRemote']) ? $configArray['dbRemote'] : $configArray['dbLocal']);
        }
        if (CONFIG_APP['envError']) {
            ini_set('display_errors', 1);
            ini_set('display_startup_errors', 1);
            error_reporting(E_ALL);
        }
    } else {
        echo 'Error: El archivo de configuración no existe.';
    }
}
function  getRemoteUpdate_dev()
{
    $ch = curl_init(CONFIG_APP['urlUpdate']);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HEADER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Authorization: Bearer ' . CONFIG_APP['appToken'],
        'Version: ' . CONFIG_APP['appVersion'],
    ]);
    curl_setopt($ch, CURLOPT_TIMEOUT, 0);
    // Ejecutar la petición cURL
    $response = curl_exec($ch);
    // Obtener el tamaño del encabezado
    $header_size = curl_getinfo($ch, CURLINFO_HEADER_SIZE);
    // Separar encabezados y cuerpo
    $header = substr($response, 0, $header_size);
    $body = substr($response, $header_size);
    return $body;
}
function agregarLinea($rutaArchivo, $log) {
    // Abre el archivo en modo de escritura al final del archivo ('a+')
    if ($archivo = fopen($rutaArchivo, 'a+')) {
        // Escribe la nueva línea al final del archivo
        fwrite($archivo, $log . PHP_EOL);        
        // Cierra el archivo
        fclose($archivo);        
        return true;
    } else {
        return false;
    }
}